% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mkqr.R
\name{fit.control}
\alias{fit.control}
\title{Auxiliary parameters to control the model fitting}
\usage{
fit.control(
  toll = 1e-04,
  h = 1,
  it.max = 50,
  K.max = 6,
  stop.if.error = TRUE,
  dev0 = NULL,
  visual = FALSE,
  visualBoot = FALSE,
  pow = c(1, 1),
  digits = NULL,
  grid = NULL,
  n.boot = 20
)
}
\arguments{
\item{toll}{Positive convergence tolerance.}

\item{h}{Positive factor (from zero to one) modifying the increments in kink parameter updates during the iterative process.}

\item{it.max}{Positive integer for the maximal number of iterations.}

\item{K.max}{Positive integer for the maximal given number of kink points.}

\item{stop.if.error}{Logical indicating if the estimation algorithm should be stopped if some kink point estimators belong to the non-admissible set. Default is FALSE which suggests removing the non-admissible change points automatically.}

\item{dev0}{Initial objective value or deviance. Default is NULL which implies that the initial value is unknown.}

\item{visual}{Logical indicating if the results of the estimation process should be printed at each iteration.}

\item{visualBoot}{Logical indicating if the results of estimation should be printed at each iteration in the bootstrap restarting process.}

\item{pow}{The powers of the pseudo covariates employed by the algorithm.}

\item{digits}{If specified, it means the desired number of decimal points of the kink estimators to be used during the iterative algorithm.}

\item{grid}{It measures how close between the two adjacent change points should be merged, default is NULL.}

\item{n.boot}{Positive integer indicating the times of bootstrap re-sampling in the bootstrap restarting algorithm, default is 20.}
}
\value{
A list with the arguments as components to be used by \emph{mkqr.fit} and \emph{mkqr.bea}.
}
\description{
This function defines auxiliary parameters that control the model fitting process.
}
\examples{
# Example usage
fit.control(K.max=8)

}
