% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birds.R
\docType{data}
\name{birds}
\alias{birds}
\title{Birds Dataset -  Subset of the North American Breeding Bird Survey Dataset}
\format{
A data frame with 600 rows and 13 columns:
\describe{
\item{Route}{An identifier for the 15 survey sites.}
\item{Year}{The year of the survey (numeric).}
\item{English_Common_Name}{The English common name of the bird species surveyed (character).}
\item{Stop1}{Count for replicate 1 at the site (numeric).}
\item{Stop2}{Count for replicate 2 at the site (numeric).}
\item{Stop3}{Count for replicate 3 at the site (numeric).}
\item{Stop4}{Count for replicate 4 at the site (numeric).}
\item{Stop5}{Count for replicate 5 at the site (numeric).}
\item{Stop6}{Count for replicate 6 at the site (numeric).}
\item{Stop7}{Count for replicate 7 at the site (numeric).}
\item{Stop8}{Count for replicate 8 at the site (numeric).}
\item{Stop9}{Count for replicate 9 at the site (numeric).}
\item{Stop10}{Count for replicate 10 at the site (numeric).}
}
}
\source{
North American Breeding Bird Survey (\url{https://www.pwrc.usgs.gov/BBS/})
}
\usage{
birds
}
\description{
#' This dataset is a subset of the North American Breeding Bird Survey, containing data collected at 15 routes in Michigan, USA.
Each route has 10 stops, and the dataset includes counts for 10 bird species.
}
\examples{
# MNM Model
#' # Example: Hurdle Model
# Data must first be reformatted to an array of dimension (R,T,S,K)
R <- 15
T <- 10
S <- 10
K <- 4
# Ensure data is ordered consistently
birds <- birds[order(birds$Route, birds$Year, birds$English_Common_Name), ]

# Create a 4D array with proper dimension
Y <- array(NA, dim = c(R, T, S, K))

# Map route, species, and year to indices
route_idx <- as.numeric(factor(birds$Route))
species_idx <- as.numeric(factor(birds$English_Common_Name))
year_idx <- as.numeric(factor(birds$Year))

# Populate the array
stop_data <- as.matrix(birds[, grep("^Stop", colnames(birds))])

for (i in seq_len(nrow(birds))) {
  Y[route_idx[i], , species_idx[i], year_idx[i]] <- stop_data[i, ]
  }

  # Assign dimnames
  dimnames(Y) <- list(
    Route = sort(unique(birds$Route)),
      Stop = paste0("Stop", 1:T),
        Species = sort(unique(birds$English_Common_Name)),
          Year = sort(unique(birds$Year))
          )

# Selecting only 5 bird species and 1 year for analysis:
Y<-Y[,,1:5,1]

\donttest{model<-MNM_fit(Y=Y, AR=FALSE, Hurdle=FALSE)}

}
\keyword{datasets}
