% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_prior_distributions.R
\name{validate_prior}
\alias{validate_prior}
\title{Validate User-Specified Prior for a Single Prior}
\usage{
validate_prior(prior_name, prior_string)
}
\arguments{
\item{prior_name}{A string representing the name of the prior (e.g., \code{prior_mean}).}

\item{prior_string}{A string specifying the prior distribution (e.g., \code{'dnorm(0, 0.001)'}).}
}
\value{
Returns \code{TRUE} if the prior is valid. Throws an error if the prior is invalid.
}
\description{
Validates a single user-defined prior to ensure it specifies a valid distribution supported by Nimble and has the correct parameters for the distribution.
}
\examples{
validate_prior("prior_mean", "dnorm(0, 0.001)")

}
