% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions.R
\name{EVSKSkewt}
\alias{EVSKSkewt}
\title{EVSK multivariate Skew-t}
\usage{
EVSKSkewt(xi, omega, alpha, m)
}
\arguments{
\item{xi}{A mean vector}

\item{omega}{A \eqn{d \times d} correlation matrix}

\item{alpha}{shape parameter d-vector}

\item{m}{degrees of freedom}
}
\value{
A list of theoretical values for the mean,   variance, skewness and
kurtosis vectors
}
\description{
Computes the theoretical values of the mean,  variance,
skewness and (excess) kurtosis vectors for the d-variate Skew-t distribution \eqn{St_d(\xi, \boldsymbol{\Omega},
\boldsymbol{\alpha},m)}
defined as
 \deqn{Y = \xi + \sqrt{\frac{m}{S^2}} \mathbf{X}}
where \eqn{\mathbf{X}} is a multivariate skew-normal random variable
\eqn{SN_d(0, \boldsymbol{\Omega} , \boldsymbol{\alpha})} and \eqn{S^2} is a \eqn{\chi^2_m}
random variable independent of \eqn{\mathbf{X}}.
}
\examples{
xi <- c(0,0,0) #
alpha <- c(10,5,0) #
omega <- diag(3) #
m <- 10 #

EVSKSkewt(xi,omega,alpha,m)
}
\references{
Gy.Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021  p.277

S. R. Jammalamadaka, E. Taufer, Gy. Terdik. On multivariate
skewness and kurtosis. Sankhya A, 83(2), 607-644.
}
\seealso{
Other Moments and cumulants: 
\code{\link{Cum2Mom}()},
\code{\link{EVSKGenHyp}()},
\code{\link{EVSKSkewNorm}()},
\code{\link{EVSKUniS}()},
\code{\link{Mom2Cum}()},
\code{\link{MomCumCFUSN}()},
\code{\link{MomCumGenHyp}()},
\code{\link{MomCumMVt}()},
\code{\link{MomCumSkewNorm}()},
\code{\link{MomCumUniS}()},
\code{\link{MomCumZabs}()}
}
\concept{Moments and cumulants}
