% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/My.stepwise.r
\name{My.stepwise.lm}
\alias{My.stepwise.lm}
\title{Stepwise Variable Selection Procedure for Linear Regression Model}
\usage{
My.stepwise.lm(Y, variable.list, in.variable = "NULL", data, sle = 0.15,
  sls = 0.15)
}
\arguments{
\item{Y}{The response variable.}

\item{variable.list}{A list of covariates to be selected.}

\item{in.variable}{A list of covariate(s) to be always included in the regression model.}

\item{data}{The data to be analyzed.}

\item{sle}{The chosen significance level for entry (SLE).}

\item{sls}{The chosen significance level for stay (SLS).}
}
\value{
A model object representing the identified "Stepwise Final Model" with the values of variance inflating factor (VIF) for all included covarites is displayed.
}
\description{
This stepwise variable selection procedure (with iterations between the 'forward' and 'backward' steps) can be applied to obtain the best candidate final linear regression model.
}
\details{
The goal of regression analysis is to find one or a few parsimonious regression models that fit the observed data well for effect estimation and/or outcome prediction. To ensure a good quality of analysis, the model-fitting techniques for (1) variable selection, (2) goodness-of-fit assessment, and (3) regression diagnostics and remedies should be used in regression analysis. The stepwise variable selection procedure (with iterations between the 'forward' and 'backward' steps) is one of the best ways to obtaining the best candidate final regression model. All the bivariate significant and non-significant relevant covariates and some of their interaction terms (or moderators) are put on the 'variable list' to be selected. The significance levels for entry (SLE) and for stay (SLS) are suggested to be set at 0.15 or larger for being conservative. Then, with the aid of substantive knowledge, the best candidate final regression model is identified manually by dropping the covariates with p value > 0.05 one at a time until all regression coefficients are significantly different from 0 at the chosen alpha level of 0.05. Since the statistical testing at each step of the stepwise variable selection procedure is conditioning on the other covariates in the regression model, the multiple testing problem is not of concern. Any discrepancy between the results of bivariate analysis and regression analysis is likely due to the confounding effects of uncontrolled covariates in bivariate analysis or the masking effects of intermediate variables (or mediators) in regression analysis.
}
\section{Warning}{

The value of variance inflating factor (VIF) is bigger than 10 in continuous covariates or VIF is bigger than 2.5 in categorical covariates indicate the occurrence of multicollinearity problem among some of the covariates in the fitted regression model.
}

\examples{
data("LifeCycleSavings")
names(LifeCycleSavings)
dim(LifeCycleSavings)
my.variable.list <- c("pop15", "pop75", "dpi")
My.stepwise.lm(Y = "sr", variable.list = my.variable.list, in.variable = c("ddpi"),
   data = LifeCycleSavings)

my.variable.list <- c("pop15", "pop75", "dpi", "ddpi")
My.stepwise.lm(Y = "sr", variable.list = my.variable.list,
   data = LifeCycleSavings, sle = 0.25, sls = 0.25)
}
\seealso{
\link{My.stepwise.glm}

\link{My.stepwise.coxph}
}
