% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NBBDesigns.R
\name{pnbbd2}
\alias{pnbbd2}
\title{PNBB Design of Type 2 (PNBBD 2)}
\usage{
pnbbd2(v)
}
\arguments{
\item{v}{Number of treatments (v>5), v should be a prime number}
}
\value{
It gives Partially Neighbour Balanced Block Designs for v, when v is any prime number.
}
\description{
A block design with neighbour effects is said to be partially neighbour balanced based on m-class association scheme if two treatments 'Theta' and 'Phi' that are mutually u-th associates (u = 1, 2,…, m) appear as neighbours (left and right) 'Mu'_1u times. The design so obtained is a ((v-1)/2) associate classes partially variance balanced design following a varying circular association scheme. When v is a prime number, the function will generate a class of partially neighbour balanced block designs. It also gives the parameters of the design, information matrix for estimating the contrast pertaining to direct and neighbour effects (both left and right) of the treatments.
}
\note{
v should be greater than 5 i.e v>5.
}
\examples{
library(NBBDesigns)
pnbbd2(7)
}
\references{
Azais, J.M., Bailey, R.A. and Monod, H. (1993)<DOI: 10.2307/2532269>."A catalogue of efficient neighbour designs with border plots".
}
