% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstNCSCop.R
\name{EstNCSCop}
\alias{EstNCSCop}
\title{Estimation of  a non-central squared copula model}
\usage{
EstNCSCop(y, family, p = 2, InitialValues = NULL)
}
\arguments{
\item{y}{(nx2) data matrix (observations or residuals) that will be transformed to pseudo-observations}

\item{family}{'Gaussian' , 't' , 'Clayton' , 'Frank' , 'Gumbel'}

\item{p}{number of non-centrality parameters to be estimated (p = 0,1,2)}

\item{InitialValues}{initial values c(a1,a2,tau) to start the estimation; otherwise pre-selected values will be used}
}
\value{
\item{theta}{Estimated parameter of the copula according to CRAN copula package}

\item{dof}{Estimated degrees of freedom, only for the Student copula}

\item{tau}{Estimated theoretical Kendall tau for the copula family}
}
\description{
This function estimates the copula parameter and the non-centrality parameters of a
non-central squared copula
}
\examples{
\donttest{
param <- c(0.8, 2.5, 0.7) ;
U <- SimNCSCop('Clayton', 250, param)
estimation <- EstNCSCop(U,'Clayton')
}


}
\references{
Section 5.1 of Nasri, Rémillard & Bouezmarni (2019). Semi-parametric copula-based models under non-stationarity,
Journal of Multivariate Analysis, 173, pages 347-365.
}
\author{
Bouchra R. Nasri, August 14, 2019
}
