% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IsoPval.nm.R
\name{IsoPval.nm}
\alias{IsoPval.nm}
\title{Calculate p-values based on permutation for both increasing and
decreasing ordered alternatives}
\usage{
IsoPval.nm(data.nm, dose, response, stat=c("E2", "Williams","Marcus",
  "M", "ModM"), niter, nano.cat=NULL)
}
\arguments{
\item{data.nm}{Nanomaterial dataset}

\item{dose}{Dose or concentration (with the same unit of measurement)}

\item{response}{Response (a certain endpoint value)}

\item{stat}{Test statistics ("\code{E2}" for the global likelihood test,
"\code{Williams}" for Williams test, "\code{Marcus}" for Marcus test,
"\code{M}" for M test or "\code{ModM}" for modified M test)}

\item{niter}{Number of permutations}

\item{nano.cat}{Name of the nanomaterial}
}
\value{
This value provides p-values based on the permutation, the plot of
  the null distribution and the observed test statistics.
}
\description{
This function calculates p-values based on permutation. The plots of
the null distribution and the observed test statistic under increasing and
decreasing ordered alternatives are also given.
}
\details{
This function is intended to be used inside the function
  \code{\link{Isotest}}. However, it can also be used to calculate p-values
  and generate the plot for one nanomaterial, with a particular unit of
  measurement of the dose, for a certain toxicity endpoint.
}
\examples{
#nm400 contains the result of genetic toxicity in vitro study of NM-400
#(Multi-walled carbon nanotubes) with associated controls
\donttest{IsoPval.nm(data.nm=nm400, dose="concentration", response="value",
           stat="E2", niter=1000)}
}
\references{
Lin D., Pramana, S., Verbeke, T., and Shkedy, Z. (2015). IsoGene:
  Order-Restricted Inference for Microarray Experiments. R package version
  1.0-24. \url{https://CRAN.R-project.org/package=IsoGene}

  Lin D., Shkedy Z., Yekutieli D., Amaratunga D., and Bijnens, L. (editors).
  (2012) Modeling Doseresponse Microarray Data in Early Drug Development
  Experiments Using R. Springer.
}
\seealso{
\code{\link{Isotest}}
}
