% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjPlot.R
\name{adjPlot}
\alias{adjPlot}
\title{Plot the adjusted p-values, raw p-values and FDR level}
\usage{
adjPlot(data.nm, data.control, id, nano, response, dose, end, end.cat,
  unit, unit.cat, stat=c("E2","Williams","Marcus","M","ModM"), niter,
  method=c("BH","BY"), control.opt=c("same","all"), set.seed, vars, FDR)
}
\arguments{
\item{data.nm}{Data containing the result of toxicity study}

\item{data.control}{Data of control values}

\item{id}{Identifier of the experiment}

\item{nano}{Name of the nanomaterial}

\item{response}{Response (endpoint value)}

\item{dose}{Dose or concentration}

\item{end}{Toxicity endpoint}

\item{end.cat}{Specific toxicity endpoint of interest}

\item{unit}{Unit of measurement of the dose}

\item{unit.cat}{Specific unit of measurement of the dose}

\item{stat}{Test statistics ("\code{E2}" for the global likelihood test,
"\code{Williams}" for Williams test, "\code{Marcus}" for Marcus test,
"\code{M}" for M test or "\code{ModM}" for modified M test)}

\item{niter}{Number of permutations}

\item{method}{Method used to adjust for the multiplicity}

\item{control.opt}{Option for the control doses if \code{unit} and
\code{unit.cat} are specified. If only control doses with the same unit of
measurement as the non-control ones are included, then specify
"\code{same}" in the \code{control.opt}. If all control doses with any
units of measurement are included, then specify "\code{all}".}

\item{set.seed}{Specify seed}

\item{vars}{Variable(s) used to subset the data}

\item{FDR}{The desired FDR to control}
}
\value{
This function generates plots of adjusted p-values, raw p-values and
  selected FDR for both directions (up and down) of the trend
}
\description{
This function generates plots of adjusted p-values, raw p-values and selected
FDR level
}
\details{
\itemize{
\item{This function calculates the p-values for each nanomaterial in the
dataset (or for each subset of data). The different types of nanomaterials
are identified by their names. Therefore, if some control values are named
differently (see: \code{\link{geninvitro}} dataset and the \code{Examples}),
a separate dataset containing only these values first needs to be created.
Controls in the new dataset can be linked to the non-control observations
belonging to the same experiment through the identifier of the experiment
(the linking is performed inside this function). In this situation, it is
necessary to have an indicator that can identify different experiments (such
as experiment ID).}
\item{If all controls in the dataset are named according to the related
nanomaterial names, \code{data.control} and \code{id} do not need to be
specified.}
\item{If doses used in the experiment are all measured in the same unit of
measurement, then specify "\code{same}" in \code{control.opt}}.
\item{Plots can also be generated for subsets of data in each nanomaterial,
by specifying the variables used to split the data in \code{vars}}.
}
}
\examples{
# Create a dataset containing controls (which are named differently)
# from geninvitro dataset:
controldata<-SubsetData(data=geninvitro, x="name", x.cat=c("control", "Control",
             "medium", "medium + BSA", "untreated"))

# Exclude controls (which are named differently) from geninvitro dataset:
invitrodata<-SubsetData(data=geninvitro, x="name", x.cat=c("control", "Control",
             "medium", "medium + BSA", "untreated"), include=FALSE)
#
\donttest{adjPlot(data.nm=invitrodata, data.control=controldata, id="experimentID",
nano="name", response="value", dose="concentration", end="endpoint",
end.cat="DNA STRAND BREAKS", unit="concentration_unit", unit.cat="ug/cm2",
stat="E2", niter=1000, method="BH", control.opt="same",
set.seed = 1234, FDR=0.05)}

}
\references{
Lin D., Pramana, S., Verbeke, T., and Shkedy, Z. (2015). IsoGene:
  Order-Restricted Inference for Microarray Experiments. R package version
  1.0-24. \url{https://CRAN.R-project.org/package=IsoGene}

  Lin D., Shkedy Z., Yekutieli D., Amaratunga D., and Bijnens, L. (editors).
  (2012) Modeling Doseresponse Microarray Data in Early Drug Development
  Experiments Using R. Springer.
}
