% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addParType.R
\name{addParType}
\alias{addParType}
\title{Fill parameter names indexes in a data set}
\usage{
addParType(pars, suffix, add.idx, overwrite = FALSE)
}
\arguments{
\item{pars}{Table of parameters to augment with additional columns}

\item{suffix}{Optional string to add to all new column
names. Maybe except `i` and `j`.}

\item{add.idx}{Add `i` and `j`? Default is `TRUE` if no suffix is supplied, and `FALSE` if a suffix is specified.}

\item{overwrite}{Overwrite non-missing values? Default is `FALSE`.}
}
\description{
Add par.type, i, j to a data.table that has parameter already
}
\details{
`addParType()` fills in data sets of Nonmem parameter values to include the following variables (columns):

\itemize{
\item parameter: THETA1 , OMEGA(1,1), SIGMA(1,1), OBJ, SAEMOBJ
\item par.name: THETA(1), OMEGA(1,1), SIGMA(1,1), OBJ, SAEMOBJ
\item par.type THETA, OMEGA, SIGMA, OBJ
\item i: 1, 1, 1, NA, NA (No indexes for OBJ)
\item i: NA, 1, 1, NA, NA (j not defined for THETA)
}

As a last step, addParameter is called with overwrite=FALSE. This fills
parameter and par.name. Combined, if parameter is in pars, it is used. If
not, par.type, i, and j are used.

In the provided data set, parameter is allowed to have thetas as
THETA(1) (the par.name format). These will however be overwritten
with the described format above.
}
\keyword{internal}
