% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.best.groups.R
\name{select.best.groups}
\alias{select.best.groups}
\title{NPI for selecting the subset of best groups}
\usage{
select.best.groups(data, S)
}
\arguments{
\item{data}{a list of numeric data vectors}

\item{S}{a vector of indices of the groups in the data list to be considered as the subset of best groups}
}
\value{
NPI lower and upper probabilities for the event that
 the next future observations from groups S are greater than all
 future observations from the other groups.
}
\description{
NPI lower and upper probabilities for the event that
the next future observations from groups S are greater than all
future observations from the other groups.
}
\examples{
# NPI lower and upper probabilities for the event that
# the next future observations from groups 1 and 3 are greater than
# all future observations from the other groups.

data(FourSources)
# Convert the dataframe to a list of groups
data2<-split(FourSources$value,FourSources$source)
select.best.groups(data2,S=c(1,3))
}
