% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma.R
\name{ILFGamma}
\alias{ILFGamma}
\title{Increased Limit Factor Curve from a Gamma severity distribution}
\usage{
ILFGamma(xLow, xHigh, shape, rate)
}
\arguments{
\item{xLow}{A positive real number -  the claim amount where the Increased Limit Factor Curve will be evaluated from.}

\item{xHigh}{A positive real number -  the claim amount where the Increased Limit Factor Curve will be evaluated to.}

\item{shape}{A positive real number - the shape parameter of the Claim Severity's Gamma distribution.}

\item{rate}{A positive real number - the rate parameter of the Claim Severity's Gamma distribution.}
}
\value{
The value of the Increased Limit Factor curve from \code{xLow} to \code{xHigh} with Claim Severity from a Gamma distribution with parameters \code{shape} and \code{rate}.
}
\description{
Increased Limit Factor Curve from a Gamma severity distribution
}
\examples{
ILFGamma(1000,700,1,0.0005)
ILFGamma(1200,1000,1.5,0.0006)
}
