% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogisWeib.r
\name{LogisWeib}
\alias{LogisWeib}
\alias{dlogis.weib}
\alias{plogis.weib}
\alias{qlogis.weib}
\alias{rlogis.weib}
\alias{hlogis.weib}
\title{Logistic-Weibull Distribution}
\usage{
dlogis.weib(x, alpha, beta, lambda, log = FALSE)
plogis.weib(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qlogis.weib(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rlogis.weib(n, alpha, beta, lambda)
hlogis.weib(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dlogis.weib}: numeric vector of (log-)densities
  \item \code{plogis.weib}: numeric vector of probabilities
  \item \code{qlogis.weib}: numeric vector of quantiles
  \item \code{rlogis.weib}: numeric vector of random variates
  \item \code{hlogis.weib}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Logistic-Weibull distribution.
}
\details{
The Logistic-Weibull distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Logistic-Weibull distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad 1 - \frac{1}{{1 + {{\left( {\exp (\lambda {x^\beta }) - 1} \right)}
^\alpha }}}\quad ;\,x \geqslant 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

Included functions are:
\itemize{
  \item \code{dlogis.weib()} — Density function
  \item \code{plogis.weib()} — Distribution function
  \item \code{qlogis.weib()} — Quantile function
  \item \code{rlogis.weib()} — Random generation
  \item \code{hlogis.weib()} — Hazard function
}
}
\examples{
x <- seq(0.1, 10, 0.2)
dlogis.weib(x, 2.0, 0.5, 0.2)
plogis.weib(x, 2.0, 0.5, 0.2)
qlogis.weib(0.5, 2.0, 0.5, 0.2)
rlogis.weib(10, 2.0, 0.5, 0.2)
hlogis.weib(x, 2.0, 0.5, 0.2)

# Data
x <- bladder
# ML estimates
params = list(alpha=2.4165, beta=0.5103, lambda=0.2711)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = plogis.weib, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qlogis.weib, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dlogis.weib, pfun=plogis.weib, plot=FALSE)
print.gofic(out)

}
\references{
Chaudhary,A.K., & Kumar, V.(2021). 
The Logistic-Weibull distribution with Properties and Applications. 
\emph{IOSR Journal of Mathematics (IOSR-JM)}, \bold{17(1)},Ser.1, 32--41.  

Dhungana, G.P.,  & Kumar, V.(2021). 
Modified Half Logistic Weibull Distribution with Statistical Properties 
and Applications. \emph{International Journal of Statistics and Reliability 
Engineering}, \bold{8(1)}, 29-39.
}
