% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModInvNHE.r
\name{ModInvNHE}
\alias{ModInvNHE}
\alias{dmod.inv.NHE}
\alias{pmod.inv.NHE}
\alias{qmod.inv.NHE}
\alias{rmod.inv.NHE}
\alias{hmod.inv.NHE}
\title{Modified Inverse NHE Distribution}
\usage{
dmod.inv.NHE(x, alpha, beta, lambda, log = FALSE)
pmod.inv.NHE(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qmod.inv.NHE(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rmod.inv.NHE(n, alpha, beta, lambda)
hmod.inv.NHE(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dmod.inv.NHE}: numeric vector of (log-)densities
  \item \code{pmod.inv.NHE}: numeric vector of probabilities
  \item \code{qmod.inv.NHE}: numeric vector of quantiles
  \item \code{rmod.inv.NHE}: numeric vector of random variates
  \item \code{hmod.inv.NHE}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Modified Inverse NHE distribution.
}
\details{
The Modified Inverse NHE distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Modified Inverse NHE distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad \exp \left\{1-\left(1+\frac{\lambda}{x} 
e^{-\beta x}\right)^\alpha\right\}  \quad ;\;x > 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The following functions are included:
\itemize{
  \item \code{dmod.inv.NHE()} — Density function
  \item \code{pmod.inv.NHE()} — Distribution function
  \item \code{qmod.inv.NHE()} — Quantile function
  \item \code{rmod.inv.NHE()} — Random generation
  \item \code{hmod.inv.NHE()} — Hazard function
}
}
\examples{
x <- seq(0.1, 10, 0.2)
dmod.inv.NHE(x, 2.0, 0.5, 0.2)
pmod.inv.NHE(x, 2.0, 0.5, 0.2)
qmod.inv.NHE(0.5, 2.0, 0.5, 0.2)
rmod.inv.NHE(10, 2.0, 0.5, 0.2)
hmod.inv.NHE(x, 2.0, 0.5, 0.2)

# Data
x <- waiting
# ML estimates
params = list(alpha=0.4858, beta=0.1099, lambda=37.5129)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = pmod.inv.NHE, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qmod.inv.NHE, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dmod.inv.NHE, pfun=pmod.inv.NHE, plot=FALSE)
print.gofic(out)

}
\references{
Chaudhary, A. K., Sapkota, L. P., & Kumar, V. (2022). 
Modified Inverse NHE Distribution: Properties and Application. 
\emph{Journal of Institute of Science and Technology}, \bold{27(1)}, 
125–-133. \doi{10.3126/jist.v27i1.46695}
}
