% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl_max_correlation.R
\name{get_predictions.cl_max_correlation}
\alias{get_predictions.cl_max_correlation}
\title{A classifier (CL) method to train the CL and return predictions}
\usage{
\method{get_predictions}{cl_max_correlation}(cl_obj, training_set, test_set)
}
\arguments{
\item{cl_obj}{The classifier object.}

\item{training_set}{The training set data from one time bin. This is a data
frame where the rows correspond to data from a given trial. There must be a
column called \code{train_labels} that has the labels of what occurred on each
trial. The rest of the  columns correspond to the neural activity of a
particular site on each trial (and typically have names like site_0001,
site_0002, etc).}

\item{test_set}{The test set data from all times. This is a data frame where
the rows correspond to data from a given trial. There must be a column
called \code{time_bin} that contains a label indicating the time point that a
row (test point) came from.  The rest of the  columns correspond to the
neural activity of a particular site on each test trial (and typically have
names like site_0001, site_0002, etc).}
}
\value{
This method returns a data frame where each row corresponds to a
prediction for one of the test points. The columns in this data frame are:
\itemize{
\item \emph{test_time}: The time bin a test point came from.
\item \emph{actual_labels}: The actual labels for what happened on a trial.
\item \emph{predicted_labels}: The predictions that classifier made.
\item \emph{decision_vals.___}: A set of columns with the decision values
for each class.
}
}
\description{
\code{get_predictions} takes a training set and a test set of data. It trains the
CL object on the training set and returns the predictions of the on the test
set. This is a generic function that must be implemented by all CL objects.
This method should not be called directly but instead it is used internally
by the cross-validator (CV) object.
}
\seealso{
\code{\link[=cl_max_correlation]{cl_max_correlation()}}, \code{\link[=cl_poisson_naive_bayes]{cl_poisson_naive_bayes()}}, \code{\link[=cl_svm]{cl_svm()}}
}
\keyword{internal}
