% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_num_label_repetitions.R
\name{get_siteIDs_with_k_label_repetitions}
\alias{get_siteIDs_with_k_label_repetitions}
\title{Get the sitesIDs that have at least k trials for all label level}
\usage{
get_siteIDs_with_k_label_repetitions(
  binned_data,
  labels,
  k,
  label_levels = NULL
)
}
\arguments{
\item{binned_data}{A string that list a path to a file that has data in
binned format, or a data frame of binned_data that is in binned format.}

\item{labels}{A string specifying which label variable should be
used when calculating the minimum number of level repetitions.}

\item{k}{A number specifying that all sitesIDs returned should have at least k
repetitions of all label levels.}

\item{label_levels}{A character vector specifying which levels to include.
If not set, all levels will be used.}
}
\value{
A vector of integers that specific which siteIDs have at least k
repetitions of each label level (from the label levels that are used).
}
\description{
This function gets the siteIDs that have at least k label level
repetitions. These siteIDs can be used in a datasource to only get data
from sites that have enough label repetitions. For example, one could use
these siteIDs in conjunction with the ds_basic's site_IDs_to_use argument
to only get data from sites that have enough repetitions of each stimulus.
}
\examples{
data_file <- system.file("extdata/ZD_150bins_50sampled.Rda", package = "NeuroDecodeR")
get_siteIDs_with_k_label_repetitions(data_file, "stimulus_ID", 5)


}
