% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_valid_NDR_objects.R
\name{test_valid_raster_format}
\alias{test_valid_raster_format}
\title{Tests if a data frame is in valid raster format}
\usage{
test_valid_raster_format(raster_data)
}
\arguments{
\item{raster_data}{A data frame or string specifying a file that will be
checked to see if it is in valid raster format.}
}
\value{
Returns NULL if object is in valid raster format. Otherwise it will
give an error message.
}
\description{
This function takes a data frame and tests that the data frame is in valid
raster format by checking that the data frame contains variables with the
appropriate names. If the data frame is not in correct raster format, an
error will be thrown that contains a message why the data is not in valid
raster format.
}
\examples{
# This is valid raster data so the function will return no error message
raster_dir_name <- file.path(
  system.file("extdata", package = "NeuroDecodeR"),
  "Zhang_Desimone_7object_raster_data_small_rda"
)
file_name <- "bp1001spk_01A_raster_data.rda"
raster_full_path <- file.path(raster_dir_name, file_name)

test_valid_raster_format(raster_full_path)


# Binned data is not in raster format (it has an extra column called siteID) so
# checking if it is in raster format should return an error.

binned_file_name <- system.file(file.path("extdata", "ZD_150bins_50sampled.Rda"), 
                                package = "NeuroDecodeR")
try(test_valid_raster_format(binned_file_name))


}
