% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NBSI.R
\name{NBSI}
\alias{NBSI}
\title{Niche-model-Based Species Identification (NBSI)}
\usage{
NBSI(
  ref.seq,
  que.seq,
  model = "RF",
  independence = TRUE,
  ref.add = NULL,
  variables = "ALL",
  en.vir = NULL,
  bak.vir = NULL
)
}
\arguments{
\item{ref.seq}{DNAbin, the reference dataset containing sample IDs,
taxon information,longitude and latitude, and barcode sequences of samples.}

\item{que.seq}{DNAbin, the query dataset containing sample IDs, longitude
and latitude, and barcode sequences of samples.}

\item{model}{Character, string indicating which niche model will be used.
Must be one of "RF" (default) or "MAXENT". "MAXENT" can only be applied when
the java program paste(system.file(package="dismo"), "/java/maxent.jar",
sep='') exists.}

\item{independence}{Logical. Whether the barcode sequences are related to
the ecological variables?}

\item{ref.add}{Data.frame, the additional coordinates collected from GBIF
or literatures.}

\item{variables}{Character, the identifier of selected bioclimate variables.
Default of "ALL" represents to use all the layers in en.vir; the alternative
option of "SELECT" represents to randomly remove the highly-correlated
variables (|r| larger than 0.9) with the exception of one layer.}

\item{en.vir}{RasterBrick, the global bioclimate data output from
"raster::getData" function.}

\item{bak.vir}{Matrix, bioclimate variables of random background points.}
}
\value{
A dataframe of barcoding identification result for each query sample
and corresponding niche model-based probability.
}
\description{
Species identification using DNA barcoding integrated with
niche model.
}
\examples{
data(en.vir)
data(bak.vir)
#envir<-raster::getData("worldclim",download=FALSE,var="bio",res=2.5)
#en.vir<-raster::brick(envir)
#back<-dismo::randomPoints(mask=en.vir,n=5000,ext=NULL,extf=1.1,
#                          excludep=TRUE,prob=FALSE,
#                          cellnumbers=FALSE,tryf=3,warn=2,
#                          lonlatCorrection=TRUE)
#bak.vir<-raster::extract(en.vir,back)

library(ape)
data(LappetMoths)
ref.seq<-LappetMoths$ref.seq[1:50,]
que.seq<-LappetMoths$que.seq[1:5,]
NBSI.out<-NBSI(ref.seq,que.seq,ref.add=NULL,
               independence=TRUE,
               model="RF",variables="SELECT",
               en.vir=en.vir,bak.vir=bak.vir)
NBSI.out

### Add a parameter when additional reference coordinates are available ###
#ref.add<-LappetMoths$ref.add
#NBSI.out2<-NBSI(ref.seq,que.seq,ref.add=ref.add,
#                independence=TRUE,
#                model="RF",variables="SELECT",
#                en.vir=en.vir,bak.vir=bak.vir)
#NBSI.out2
}
\references{
Breiman, L. 2001. Random forests. Machine Learning 45(1):5-32.

Liaw, A. and M. Wiener. 2002. Clasification and regression by
randomForest. R News, 2/3:18-22.

Phillips, S.J., R.P. Anderson and R.E. Schapire. 2006. Maximum
entropy modeling of species geographic distributions. Ecological Modelling,
190:231-259.

Zhang, A.B., M.D. Hao, C.Q. Yang and Z.Y. Shi. (2017). BarcodingR:
an integrated R package for species identification using DNA barcodes.
Methods in Ecology and Evolution, 8:627-634.

Jin, Q., H.L. Han, X.M. Hu, X.H. Li, C.D. Zhu, S.Y.W. Ho, R.D. Ward
and A.B. Zhang. 2013. Quantifying species diversity with a DNA barcoding-based
method: Tibetan moth species (Noctuidae) on the Qinghai-Tibetan Plateau.
PloS One, 8:e644.

Hijmans, R.J., S.E. Cameron, J.L. Parra, P.G. Jones and A. Jarvis.
2005. Very high resolution interpolated climate surfaces for global land areas.
International Journal of Climatology, 25(15):1965-1978.
}
\author{
Cai-qing YANG (Email: yangcq_ivy(at)163.com) and Ai-bing ZHANG
(Email:zhangab2008(at)cnu.edu.cn), Capital Normal University (CNU), Beijing,
CHINA.
}
\keyword{NBSI}
