% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{getcv}
\alias{getcv}
\title{calculate critical values}
\usage{
getcv(alpha = 0.05, method = "ps", eta = 0.5, simul = 0)
}
\arguments{
\item{alpha}{a number in \eqn{(0,1)}, indicating the significance level of
the test.}

\item{method}{``ps'' for the partial-sum staistic, others for the worst-case
statistic.}

\item{eta}{a number in \eqn{[0,1]}, a scaling parameter required for "ps"
method; see more details in He et al. (2021).}

\item{simul}{logical value, woking only for "ps" method with
\eqn{\eta} not equal to 0.5.  When \emph{simul} is true, the
function will return approximated critical values based on 50000
replications of simulated Wiener process on a grid of 10000 points in
\eqn{[0,1]}. Otherwise, the function first checks for the nearest pair of
\eqn{(\eta,\alpha)} in the preserved \emph{cv.table}, and
then returns the corresponding critical value.}
}
\value{
a real number.
}
\description{
This function calculates critical values for the partial-sum and worst-case
statistics.
}
\details{
For the partial-sum statistic with \eqn{\eta=0.5} or the worst-case
statistic, the critical value is simply \eqn{-log(-log(1-alpha))}. For the
partial-sum statistic with \eqn{\eta} not equal to 0.5, the critical
value of the scaled Wiener process is approximated by simulated data or from
our preserved table \emph{cv.table}, covering \eqn{\eta} in
\eqn{[0.01,0.49]} with step size equal to 0.01 and \eqn{\alpha} in
\eqn{[0.001,0.500]} with step size equal to 0.001. See more details for the
test statistics in He et al. (2021).
}
\examples{
\dontrun{
getcv(0.05,method="ps",eta=0.25)
getcv(0.05,method="ps",eta=0.25,simul=1)
getcv(0.10,method="wc")
}
}
\references{
He Y, Kong X, Trapani L, & Yu L(2021). Online change-point
detection for matrix-valued time series with latent two-way factor
structure. \emph{arXiv preprint}, arXiv:2112.13479.
}
\author{
Yong He, Xinbing Kong, Lorenzo Trapani, Long Yu
}
