% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSCV_regfunctions.R
\name{CV_reg}
\alias{CV_reg}
\title{The cross-validation (CV) function in the regression context.}
\usage{
CV_reg(h, desx, y)
}
\arguments{
\item{h}{numerical vector of bandwidth values,}

\item{desx}{numerical vecror of design points,}

\item{y}{numerical vecror of data values corresponding to the design points \eqn{desx}.}
}
\value{
The vector of values of \eqn{CV(h)} for the correponsing vector of \eqn{h} values.
}
\description{
Computing \eqn{CV(h)}, the value of the CV function in the regression context.
}
\details{
The CV function is a measure of fit of the regression estimate to the data. The local linear estimator based on the Gaussian kernel is used. The cross-validation bandwidth is the minimizer of the CV function.
}
\examples{
\dontrun{
# Example (Old Faithful geyser). Take x=waiting time; y=eruption duration. The sample size n=272.
xdat=faithful[[2]]
ydat=faithful[[1]]
harray=seq(0.5,10,len=100)
cv=CV_reg(harray,xdat,ydat)
R=range(xdat)
h_cv=round(optimize(CV_reg,c(0.01,(R[2]-R[1]/4)),desx=xdat,y=ydat)$minimum,digits=4)
dev.new()
plot(harray,cv,'l',lwd=3,xlab="h",ylab="CV(h)",main="CV function for the Old Faithful 
geyser data", cex.lab=1.7,cex.axis=1.7,cex.main=1.5)
legend(6,0.155,legend="n=272",cex=1.8,bty="n")
legend(1,0.18,legend=paste("h_CV=",h_cv),cex=2,bty="n")
}
}
\references{
Stone, C.J. (1977) Consistent nonparametric regression. \emph{Annals of Statistics}, 5(4), 595-645.
}
\seealso{
\code{\link{loclin}}, \code{\link{h_ASE_reg}}, \code{\link{ASE_reg}}, \code{\link{OSCV_reg}}.
}
