% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSCV_density.R
\name{OSCV_Epan_dens}
\alias{OSCV_Epan_dens}
\title{The OSCV function based on \eqn{L_E}, the one-sided Epanechnikov kernel, in the kernel density estimation (KDE) context.}
\usage{
OSCV_Epan_dens(h, dat)
}
\arguments{
\item{h}{numerical vector of bandwidth values,}

\item{dat}{numerical vecror of data values.}
}
\value{
The vector of values of the OSCV function for the correponsing vector of \eqn{h} values.
}
\description{
Computing the values of the \eqn{L_E}-based OSCV function in the density estimation context. See Martinez-Miranda et al. (2009) and Savchuk (2017).
}
\details{
Computing the values of the OSCV function for the given bandwidth vector \eqn{h} and data vector \eqn{dat}. The function is based on the one-sided Epanechnikov kernel \eqn{L_E}. The function's minimizer is to be multiplied by the appropriate rescaling constant before it can be used to compute the ultimate kernel density estimate. The formula for the rescaling constant depends on \emph{smothness} of the density and on the \emph{kernel} used in computing the ultimate density estimate.
}
\examples{
\dontrun{
# Example 1 (Data on n=272 eruption duration of the Old Faithful geyser).
data=faithful[,1]
har=seq(0.05,1,len=1000)
dev.new()
plot(har,OSCV_Epan_dens(har,data),lwd=3,'l',xlab="h",ylab="L_E-based OSCV",
main="L_E_based OSCV for the data on eruption duration",cex.main=1.5,cex.lab=1.7,cex.axis=1.7)
h_min=round(optimize(OSCV_Epan_dens,c(0.001,1),tol=0.001,dat=data)$minimum, digits=4)
legend(0.1,-0.1,legend=c("n=272",paste("h_min=",h_min)),cex=2)
# The above graph appears in Savchuk (2017).

# Example 2 (Data set of size n=100 is generated from the standard normal density).
dat_norm=rnorm(100)
harray=seq(0.25,4.25,len=1000)
OSCVarray=OSCV_Epan_dens(harray,dat_norm)
dev.new()
plot(harray,OSCVarray,lwd=3,'l',xlab="h",ylab="L_E-based OSCV",
main="L_E-based OSCV for data generated from N(0,1)", cex.main=1.5,cex.lab=1.7,cex.axis=1.7)
h_min_norm=round(optimize(OSCV_Epan_dens,c(0.1,4),tol=0.001,dat=dat_norm)$minimum, digits=4)
legend(0.5,OSCVarray[1],legend=c("n=100",paste("h_min=",h_min_norm)),cex=2,bty="n")
}
}
\references{
\itemize{
  \item Martinez-Miranda, M.D., Nielsen, J. P., and Sperlich, S. (2009). One sided cross validation for density estimation. In \emph{Operational Risk Towards Basel III: Best Practices and Issues in Modeling, Management and Regulation}, 177-196.
  \item Savchuk, O.Y. (2017). One-sided cross-validation for nonsmooth densty functions, arXiv:1703.05157.
}
}
\seealso{
\code{\link{OSCV_Gauss_dens}}, \code{\link{OSCV_LI_dens}}.
}
