% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSCV_regfunctions.R
\name{loclin}
\alias{loclin}
\title{Computing the local linear estimate (LLE).}
\usage{
loclin(u, desx, y, h)
}
\arguments{
\item{u}{numerical vector of argument values,}

\item{desx}{numerical vecror of design points,}

\item{y}{numerical vecror of data values (corresponding to the specified design points \eqn{desx}),}

\item{h}{numerical bandwidth value (scalar).}
}
\value{
Numerical vector of the LLE values computed over the specified vector of \eqn{u} points.
}
\description{
Computing the LLE based on data \eqn{(desx,y)} over the given vector of the argument values \eqn{u}. The Gausssian kernel is used. See expression (3) in Savchuk and Hart (2017).
}
\details{
Computing the LLE based on the Gaussian kernel for the specified vector of the argument values \eqn{u} and given vectors of design points \eqn{desx} and the corresponding data values \eqn{y}.
}
\examples{
\dontrun{
# Example (simulated data).
n=200
dx=(1:n-0.5)/n
regf=2*dx^10*(1-dx)^2+dx^2*(1-dx)^10
u=seq(0,1,len=1000)
ydat=regf+rnorm(n,sd=0.002)
dev.new()
plot(dx,regf,'l',lty="dashed",lwd=3,xlim=c(0,1),ylim=c(1.1*min(ydat),1.1*max(ydat)),
cex.axis=1.7,cex.lab=1.7)
title(main="Function, generated data, and LLE",cex.main=1.5)
points(dx,ydat,pch=20,cex=1.5)
lines(u,loclin(u,dx,ydat,0.05),lwd=3,col="blue")
legend(0,1.1*max(ydat),legend=c("LLE based on h=0.05","true regression function"),
lwd=c(2,3),lty=c("solid","dashed"),col=c("blue","black"),cex=1.5,bty="n")
legend(0.7,0.5*min(ydat),legend="n=200",cex=1.7,bty="n")
}
}
\references{
\itemize{
  \item Clevelend, W.S. (1979). Robust locally weighted regression and smoothing scatterplots. \emph{Journal of the American Statistical Association}, 74(368), 829-836.
  \item  Savchuk, O.Y., Hart, J.D. (2017). Fully robust one-sided cross-validation for regression functions. \emph{Computational Statistics}, doi:10.1007/s00180-017-0713-7.
}
}
\seealso{
\code{\link{OSCV_reg}}, \code{\link{h_OSCV_reg}}, \code{\link{ASE_reg}}, \code{\link{h_ASE_reg}}, \code{\link{CV_reg}}.
}
