% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{GiniMulti}
\alias{GiniMulti}
\title{A function to compute multigroup Gini index}
\usage{
GiniMulti(x)
}
\arguments{
\item{x}{an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a group within 
spatial units. The number of columns should be greater than 1 (at least 2 
groups are required). You should not include a column with total 
population, because this will be interpreted as a group.}
}
\value{
The multigroup Gini index value (numeric)
}
\description{
multigroup Gini is a multigroup version of 
the \code{\link{Gini}} index
}
\examples{
x <- segdata@data[ ,1:2]
GiniMulti(x) 
}
\references{
Reardon S. F. (1998) \emph{Measures of racial 
diversity and segregation in multigroup and hierarchical 
structured Populations}. Annual meeting of the Eastern 
Sociological Society, Philadelphia
}
\seealso{
multigroup indices: 
\code{\link{PMulti}}, \code{\link{GiniMulti}},   
\code{\link{HMulti}}, \code{\link{CMulti}}, \code{\link{RelDivers}}

Social diversity indices: 
\code{\link{HShannon}}, \code{\link{NShannon}}, 
\code{\link{ISimpson}},
}
