% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{LQ}
\alias{LQ}
\title{A function to compute location quotients (LQs)}
\usage{
LQ(x)
}
\arguments{
\item{x}{an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a group within 
spatial units. The number of columns should be greater than 1 (at least 2 
groups are required). You should not include a column with total 
population, because this will be interpreted as a group.}
}
\value{
A matrix containing the location quotients for each group in each spatial unit
}
\description{
Location quotients compare the relative part of a 
group in a particular spatial unit, to the relative part of that 
same group in the area.
}
\examples{
x <- segdata@data[ ,1:2]
LQ(x) 
}
\references{
Isard W. (1960) \emph{Methods of regional analysis: 
an introduction to regional science}. The MIT Press, Cambridge
}
\seealso{
Other local indices \code{\link{LShannon}}
\code{\link{HLoc}}, \code{\link{LSimpson}}
}
