write.table <- function(x, file = "", sep =" ", col.names = TRUE,
			row.names = TRUE, quote = FALSE, na = NA,
			eol = "\n")
{
  if (is.data.frame(x) && is.logical(quote) && quote)
    quote <- which(unlist(lapply(x, is.character)))
  x <- as.matrix(x)
  p <- ncol(x)
  d <- dimnames(x)
  x[is.na(x)] <- na
  if (is.logical(quote))
    quote <- if (quote && is.character(x)) 1 : p else NULL
  else if (is.numeric(quote)) {
    if (any(quote < 1 | quote > p))
      stop("invalid numbers in quote")
  }
  else
    stop("invalid quote specification")
      
  if (is.logical(row.names)) {
    if (row.names)
      x <- cbind(d[[1]], x)
  }
  else {
    row.names <- as.character(row.names)
    if (length(row.names) == nrow(x))
      x <- cbind(row.names, x)
    else
      stop("invalid row.names specification")
  }
  if (!is.null(quote) && (p < ncol(x)))
    quote <- c(0, quote) + 1

  APPEND <- FALSE
  if (is.logical(col.names))
    col.names <- if (col.names) d[[2]] else NULL
  else {
    col.names <- as.character(col.names)
    if (length(col.names) != p)
      stop("invalid col.names specification")
  }
  if (!is.null(col.names)) {
    if (!is.null(quote))
      col.names <- paste("\"", col.names, "\"", sep = "")
    cat(col.names, file = file, sep = rep(sep, p - 1))
    cat(eol, file = file, append = TRUE)
    APPEND <- TRUE
  }

  for (i in quote)
    x[, i] <- paste("\"", x[, i], "\"", sep = "")

  cat(t(x), file = file, sep = c(rep(sep, ncol(x) - 1), eol),
      append = APPEND)
}
