/* gee support @(#) normlib.c 4.4 96/09/27 */

#include "chanmat.h"

/* normlib.c */
/*-------------------------------------------------*/

/* library  of routines to support VC_GEE_npdf() and VC_GEE_ncdf() functions to 
   compute the normal pdf and cdf used in adding the probit link to gee
   code added by pj catalano                                               */


/* dependence on Numerical Recipes code removed by Thomas Lumley */
/* normal pdf/cdf now taken from internal R routines (more accurate, too) */

extern double dnorm(double, double, double);
extern double pnorm(double, double, double);


double VC_GEE_ncdf();			     /* returns cum prob of x */
double VC_GEE_npdf();			     /* returns pdf of std normal */
/* added by pj catalano to support probit link option in cgee.c */
   
MATRIX *VC_GEE_matnpdf( x )
MATRIX *x;
{
double *load, *look;
double VC_GEE_npdf();
MATRIX *tmp;
int nelem, i;

nelem = get_nelem( x );
tmp = VC_GEE_create_matrix( x->nrows, x->ncols , EPHEMERAL );
load = tmp->data;
look = x->data;
for ( i = 0 ; i < nelem ; i++ )
   *(load++) = dnorm(*look++, (double) 0, (double) 1);
  /*	*(load++) = VC_GEE_npdf(*look++);*/
free_if_ephemeral(x);
return tmp ;
}

MATRIX *VC_GEE_matncdf( x )
MATRIX *x;
{
double *load, *look;
double VC_GEE_ncdf();
MATRIX *tmp;
int nelem, i;

nelem = get_nelem( x );
tmp = VC_GEE_create_matrix( x->nrows, x->ncols , EPHEMERAL );
load = tmp->data;
look = x->data;
for ( i = 0 ; i < nelem ; i++ ){
     *(load++) = pnorm(*look++, (double) 0.0, (double) 1.0);
}
  /*	*(load++) = VC_GEE_ncdf(*look++); */
free_if_ephemeral(x);
return tmp ;
}

/* end of pj catalano additions  */
