library.dynam("survival4.so")


require(splines)

"model.data.frame" <-
function (...) 
{
	cn <- as.character(substitute(list(...))[-1])
	rval<-data.frame(..., col.names = cn, as.is = TRUE)
	names(rval)<-cn
	rval
}
"MyUseMethod" <-
function (generic, classobj = NULL) 
{ 
        call <- sys.call(sys.parent())
	if (is.null(classobj)) 
		classobj <- eval(call[[2]], sys.frame(sys.parent()))
	classlist <- class(classobj)
	classlist <- c(classlist, "default")
	while (!exists(paste(generic, classlist[[1]], sep = "."
	),mode="function",inherits=TRUE) && length(classlist) > 1) classlist <- classlist[-1]
        methodname<-paste(generic, classlist[[1]], sep = "."
	)
	if (!exists(methodname,mode="function",inherits=TRUE))
		stop("No method found")
	call[[1]] <- as.name(methodname)
	eval(call, sys.frame(-2))
}

delete.response<- function (termobj) 
	terms(reformulate(attr(termobj, "term.labels"), NULL),
		 specials = names(attr(termobj, "specials"))
		)

all.equal <- function(x,y){
	 as.logical(prod(as.numeric((abs(x-y)<.Machine$double.eps) || (is.na(x) && is.na(y)))))
}
"reformulate" <- function (termlabels, response = NULL) 
{
  if (is.null(response)){
    termtext<-paste("~", paste(termlabels, collapse = "+"),collapse = "")
    termobj<-eval(parse(text = termtext)[[1]])
  }
  else {
    termtext <- paste("response", "~", paste(termlabels, collapse = "+"), 
		collapse = "")
	termobj <- eval(parse(text = termtext)[[1]])
	termobj[[2]] <- response
  }
	termobj
}


drop.terms <-function(termobj, dropx = NULL, keep.response = F) 
{
	if (is.null(dropx)) 
		termobj
	else {
		newformula <- reformulate(attr(termobj, "term.labels")[-dropx], if (keep.response) termobj[[2]] else NULL)
		terms(newformula, specials = names(attr(termobj, "specials")))
	}
}

"pmin" <- function (..., na.rm = FALSE) 
{
	elts <- list(...)
	minmm <- as.vector(elts[[1]])
	for (each in elts[-1]) {
		work <- cbind(minmm, as.vector(each))
		nas <- is.na(work)
		work[, 1][nas[, 1]] <- work[, 2][nas[, 1]]
		work[, 2][nas[, 2]] <- work[, 1][nas[, 2]]
		change <- work[, 1] > work[, 2]
		work[, 1][change] <- work[, 2][change]
		if (!na.rm) 
			work[, 1][nas[, 1] + nas[, 2] > 0] <- NA
		minmm <- work[, 1]
	}
	attributes(minmm)<-attributes(elts[[1]])
	minmm
}

"pmax" <- function (..., na.rm = FALSE) 
{
	elts <- list(...)
	maxmm <- as.vector(elts[[1]])
	for (each in elts[-1]) {
		work <- cbind(maxmm, as.vector(each))
		nas <- is.na(work)
		work[, 1][nas[, 1]] <- work[, 2][nas[, 1]]
		work[, 2][nas[, 2]] <- work[, 1][nas[, 2]]
		change <- work[, 1] < work[, 2]
		work[, 1][change] <- work[, 2][change]
		if (!na.rm) 
			work[, 1][nas[, 1] + nas[, 2] > 0] <- NA
		maxmm <- work[, 1]
	}
	attributes(maxmm)<-attributes(elts[[1]])
	maxmm
}
"[.Surv" <-function (xx, i=NULL, j=NULL, drop = F) 
{
  x<-xx
	temp <- class(x)
	type <- attr(x, "type")
	class(x) <- NULL
	attr(x, "type") <- NULL
	if (missing(j)) {
		x <- x[i, , drop = drop]
		class(x) <- temp
		attr(x, "type") <- type
		x
	}
	else subsetfix(x,i,j,drop=drop | missing(drop))
}
"subsetfix" <-
function (x, i = NULL, j = NULL, drop = F) 
{
	y <- x
	y <- data.frame(y)
	if (is.null(i)) {
		if (is.null(j)) {
			return(x)
		}
		else { 
		  if (length(j)>1){
		    return(as.matrix(y[,j,drop=drop]))
		  }
		  else{
			return(unclass(y[, j, drop = drop]))
		      }
		}
	}
	else {
		if (is.null(j)) {
			return(unclass(y[i, , drop = drop]))
		}
		else {
			return(unclass(y[i, j, drop = drop]))
		}
	}
}


#data.frame<- function (..., row.names = NULL, col.names = NULL, as.is = FALSE) 
#{
##	frame <- list(...)
#	if (is.null(col.names)) {
#		v <- substitute(list(...))[-1]
#		for (i in 1:length(v)) if (!is.symbol(v[[i]])) 
#			v[[i]] <- paste("X", i, sep = "")
#		arg.names <- as.character(v)
#		col.names <- names(frame)
#		if (is.null(col.names)) 
#			col.names <- arg.names
#		else {
#			nameless <- (nchar(col.names) == 0)
#			col.names[nameless] <- arg.names[nameless]
#		}
#	}
#	names(frame) <- as.character(col.names)
#	for (i in 1:length(frame)) if (is.list(frame[[i]])) 
#		for (j in 1:length(frame[[i]])) {
#			if (!is.numeric(frame[[i]][[j]]) && !is.factor(frame[[i]][[j]])) 
#				frame[[i]][[j]] <- numeric.or.factor(frame[[i]][[j]])
#		}
#	else {
#		if (!is.numeric(frame[[i]]) && !is.factor(frame[[i]])) 
#			frame[[i]] <- numeric.or.factor(frame[[i]])
#	}
#	nn<-names(frame)
#	rval <-.Internal(data.frame(frame, as.character(row.names), as.logical(as.is)))
#	rval
#}



 sort.list<-function(...) order(...)

"[.formula"<-function(f,i,...){ 
  tt<-terms.formula(f)[i]
  attributes(tt)<-list(class="formula") 
  tt
}

"[.terms"<-function(termobj,i){
  resp<-if (attr(termobj,"response")) termobj[[2]] else NULL
  newformula<-reformulate(attr(termobj, "term.labels")[i], resp)
  terms(newformula, specials = names(attr(termobj, "specials")))
}

is.category <- function(x) inherits(x,"factor") || is.factor(x)

"model.frame" <-function (formula, data = sys.frame(sys.parent()), subset = NULL, na.action = eval(as.name(options("na.action")$na.action)), use.data = TRUE, process.offsets = TRUE, ...) 
{ 
        if (!is.null(formula$model) && missing(data)) 
	  return(formula$model)

	if (!missing(data) || is.null(formula$model.frame)) {
		dotsdata <- if (use.data) 
			data
		else sys.frame(sys.parent())
		newframe <- substitute(list(...))
		dots <- eval(newframe, dotsdata)
		if (!is.null(dots)) {
			real.dots <- !unlist(lapply(dots, is.null))
			newframe <- as.call(newframe[c(T, real.dots)])
			dots <- dots[real.dots]
		}
		Terms <- terms(formula)
		frame <- attr(Terms, "variables")
		name.process <- function(x) paste("(", x, ")", sep = "")
		if (missing(data)) {
		  if (is.null(formula$call$data))
		    data<-environment(NULL)
		  else
		    data <- eval(formula$call$data)
		}
		if (!(missing(subset) || exists(as.character(match.call()$subset), inherits = FALSE
		))) 
			subset <- eval(match.call()$subset, data)
		if (is.null(dots)) 
			rval <- na.action(eval(frame, data)[subset, , drop = FALSE])
		else {
			dotnames <- sapply(names(eval(dots, data)), name.process)
			val <- eval(frame, data)
			newframe[[1]] <- as.name("model.data.frame")
			for (i in 1:length(dots)) newframe[[i + 1]] <- dots[[i]]
			dotsval <- eval(newframe, dotsdata)
			names(dotsval) <- dotnames
			if (dim(val)[1] == dim(dotsval)[1]) 
				newval <- c(val, dotsval)
			else stop("Mismatched dimensions in model.frame")
			class(newval) <- "data.frame"
			rval <- na.action(newval[subset, , drop = FALSE])
		}
		attr(rval, "terms") <- Terms
		offset.pos <- attr(Terms, "offset")
		if (process.offsets && (length(offset.pos) > 0)) {
			offset.total <- as.vector(as.matrix(rval[, offset.pos]) %*% rep(1, length(offset.pos
			)))
			rval[[offset.pos[1]]] <- offset.total
			names(rval)[offset.pos[1]] <- "(offset)"
		}
		rval
	}
	else formula$model.frame
}







