\name{agnes.object}
\title{
Agglomerative Nesting Object
}
\section{GENERATION}{
This class of objects is returned from \code{agnes}.


}
\section{METHODS}{
The \code{"agnes"} class has methods for the following generic functions:
\code{print}, \code{summary}, \code{plot}, \code{pltree}.


}
\section{STRUCTURE}{
A legitimate \code{agnes} object is a list with the following components:


}
\arguments{
\item{order}{
a vector giving a permutation of the original objects to allow for plotting,
in the sense that the branches of a clustering tree will not cross.


}
\item{height}{
a vector with the distances between merging clusters at the successive
stages.


}
\item{ac}{
the agglomerative coefficient, measuring the clustering structure of the
dataset.
For each object i, denote by m(i) its dissimilarity to the first cluster
it is merged with, divided by the dissimilarity of the merger in the
final step of the algorithm.
The \code{ac} is the average of all 1 - m(i). It can also be seen as the average
width (or the percentage filled) of the banner plot.
Because \code{ac} grows with the number of objects, this measure should not
be used to compare datasets of very different sizes.


}
\item{merge}{
an (n-1) by 2 matrix, where n is the number of objects. Row i of \code{merge}
describes the merging of clusters at step i of the clustering. If a number
j in the row is negative, then the single object |j| is merged at this
stage. If j is positive, then the merger is with the cluster formed at
stage j of the algorithm.


}}
\seealso{
\code{\link{agnes}}, \code{\link{plot.agnes}}, \code{\link{pltree.agnes}}, \code{\link{diana}}, \code{\link{hclust}}.


}
\keyword{all}
\keyword{cluster}
% Converted by Sd2Rd version 0.2-a3.
