      SUBROUTINE CLARA(NN,JPP,KK,X,NRAN,NSAM,DYS,MDATA,VALMD,JTMD,NDYST,
     F NREPR,NSEL,NBEST,NR,NRX,RADUS,TTD,RATT,TTBES,RDBES,RABES,
     F MTT,AZBA,AVSYL,TTSYL,SYLINF,JSTOP,
     F TMP1,TMP2,TMP3,NTMP1,NTMP2,NTMP3,NTMP4,NTMP5,NTMP6)
CC    CLUSTERING LARGE APPLICATIONS
CC
CC    CLUSTERING PROGRAM BASED UPON THE K-MEDOID APPROACH,
CC    AND SUITABLE FOR DATA SETS OF AT LEAST 100 OBJECTS.
CC    (FOR SMALLER DATA SETS, PLEASE USE PROGRAM PAM.)
CC
CC   THE FOLLOWING VECTORS AND MATRICES MUST BE DIMENSIONED IN
CC   THE MAIN PROGRAM:
CC        X(NN*JPP)
CC        JTMD(JPP),VALMD(JPP)
CC        NREPR(NSAM),NSEL(NSAM),NBEST(NSAM),DYS(1 + NSAM*(NSAM-1)/2)
CC        NR(KK),NRX(KK),TTD(KK),RADUS(KK),RATT(KK)
CC        TTBES(KK),RDBES(KK),RABES(KK)
CC
CC   WHERE:
CC        NN = NUMBER OF OBJECTS
CC        JPP = NUMBER OF VARIABLES
CC        NSAM = NUMBER OF OBJECTS DRAWN FROM DATA SET
CC        KK = NUMBER OF CLUSTERS
CC

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(NN*JPP)
      DIMENSION JTMD(JPP),VALMD(JPP)
      DIMENSION NREPR(NSAM),NSEL(NSAM),NBEST(NSAM)
      DIMENSION DYS(1 + NSAM*(NSAM-1)/2)
      DIMENSION NR(KK),NRX(KK),TTD(KK),RADUS(KK),RATT(KK)
      DIMENSION TTBES(KK),RDBES(KK),RABES(KK),MTT(KK)
      DIMENSION SYLINF(NSAM,4),AVSYL(KK)
      DIMENSION TMP1(NSAM),TMP2(NSAM),TMP3(NSAM)
      DIMENSION NTMP1(NSAM),NTMP2(NSAM),NTMP3(NSAM)
      DIMENSION NTMP4(NSAM),NTMP5(NSAM),NTMP6(NSAM)
      INTEGER*4 NRUN

      JSTOP=0
      RNN=NN
      NNEQ=0
      IF(NN.EQ.NSAM) NNEQ=1
      NHALF=NSAM*(NSAM-1)/2+1
      NSAMB=2*NSAM
      NNPP=NN*JPP

CC
CC   IN DO 400, RANDOM SUBSAMPLES ARE DRAWN AND PARTITIONED
CC   INTO KK CLUSTERS
CC
  120 NUNFS=0
      LESS=NSAM
      IF(NN.LT.NSAMB)LESS=NN-NSAM
      KALL=0
      NRUN=0
      DO 400 JRAN=1,NRAN
      JHALT=0
      IF(NNEQ.EQ.0)GO TO 140
      IF(NNEQ.EQ.2)GO TO 400
      NNEQ=2
      DO 130 J=1,NSAM
      NSEL(J)=J
  130 CONTINUE
      GO TO 320
  140 NTT=0
      IF(JRAN.EQ.1.OR.NUNFS.EQ.JRAN.OR.NN.LT.NSAMB)GO TO 180
      DO 150 JK=1,KK
      NSEL(JK)=NRX(JK)
  150 CONTINUE
      KKM=KK-1
      DO 170 JK=1,KKM
      NSM=NSEL(JK)
      KKP=JK+1
      JSM=JK
      DO 160 JKK=KKP,KK
      IF(NSEL(JKK).GE.NSM)GO TO 160
      NSM=NSEL(JKK)
      JSM=JKK
  160 CONTINUE
      NSEL(JSM)=NSEL(JK)
      NSEL(JK)=NSM
  170 CONTINUE
      NTT=KK
      GO TO 210
  180 CALL RANDM(NRUN,RAN)
      KRAN=RNN*RAN+1.
      IF(KRAN.GT.NN)KRAN=NN
      IF(JRAN.EQ.1)GO TO 200
      DO 190 JK=1,KK
      IF(KRAN.EQ.NRX(JK))GO TO 180
  190 CONTINUE
  200 NTT=NTT+1
      NSEL(NTT)=KRAN
      IF (LESS.EQ.NTT)GO TO 290
  210 CALL RANDM(NRUN,RAN)
      KRAN=RNN*RAN+1.
      IF(KRAN.GT.NN)KRAN=NN
      IF(JRAN.EQ.1)GO TO 230
      IF(NN.GE.NSAMB)GO TO 230
      DO 220 JK=1,KK
      IF(KRAN.EQ.NRX(JK))GO TO 210
  220 CONTINUE
  230 DO 260 KANS=1,NTT
      IF(NSEL(KANS).LT.KRAN)GO TO 260
      IF(NSEL(KANS).EQ.KRAN)GO TO 210
      GO TO 270
  260 CONTINUE
      NTT=NTT+1
      NSEL(NTT)=KRAN
      GO TO 290
  270 DO 280 NAD=KANS,NTT
      NADV=NTT-NAD+KANS
      NADVP=NADV+1
      NSEL(NADVP)=NSEL(NADV)
  280 CONTINUE
      NTT=NTT+1
      NSEL(KANS)=KRAN
  290 IF(NTT.LT.LESS)GO TO 210
      IF(NN.GE.NSAMB)GO TO 320
      NEXAP=1
      NEXBP=1
      JN=0
  300 JN=JN+1
      IF(NSEL(NEXAP).EQ.JN)THEN
         NEXAP=NEXAP+1
      ELSE
         NREPR(NEXBP)=JN
         NEXBP=NEXBP+1
      ENDIF
      IF(JN.LT.NN)GO TO 300
      DO 310 NSUB=1,NSAM
      NSEL(NSUB)=NREPR(NSUB)
  310 CONTINUE
  320 CALL DYSTA2(NSAM,JPP,NSEL,X,NN,DYS,NDYST,JTMD,VALMD,
     F JHALT)
      IF(JHALT.EQ.1)GO TO 400
      KALL=1
      S=0.0
      L=1
  340 L=L+1
      IF(DYS(L).GT.S)S=DYS(L)
      IF(L.LT.NHALF)GO TO 340
      CALL BSWAP2(KK,NSAM,NREPR,DYS,Z,S,TMP1,TMP2,TMP3)
      CALL SELEC(KK,NN,JPP,NDYST,ZB,NSAM,MDATA,
     F JTMD,VALMD,NREPR,NSEL,DYS,X,NR,NAFS,TTD,RADUS,RATT,
     F NTMP1,NTMP2,NTMP3,NTMP4,NTMP5,NTMP6,TMP1,TMP2)
      NUNFS=NUNFS+NAFS
      IF(NAFS.EQ.1)GO TO 400
      IF(JRAN.EQ.1)GO TO 350
      IF(ZB.GE.ZBA)GO TO 400
  350 ZBA=ZB
      DO 345 JJB=1,KK
      TTBES(JJB)=TTD(JJB)
      RDBES(JJB)=RADUS(JJB)
      RABES(JJB)=RATT(JJB)
  345 CONTINUE
      DO 360 JK=1,KK
      NRX(JK)=NR(JK)
  360 CONTINUE
      DO 370 JS=1,NSAM
      NBEST(JS)=NSEL(JS)
  370 CONTINUE
      SX=S
  400 CONTINUE
      IF(NUNFS.LT.NRAN) GOTO 450
      JSTOP=1
      RETURN
CC
CC   FOR THE BEST SUBSAMPLE, THE OBJECTS OF THE ENTIRE DATA SET
CC   ARE ASSIGNED TO THEIR CLUSTERS 
CC
  450 IF(KALL.EQ.1)GO TO 460
      JSTOP=2
      RETURN
  460 AZBA=ZBA/RNN
      IF(KK.NE.1)GO TO 470
      GO TO 500
  470 CALL DYSTA2(NSAM,JPP,NBEST,X,NN,DYS,NDYST,JTMD,VALMD,
     F JHALT)
      CALL RESUL(KK,NN,JPP,NDYST,MDATA,JTMD,VALMD,
     F X,NRX,MTT)
  480 CALL BLACK(KK,JPP,NN,NSAM,NBEST,DYS,SX,X,AVSYL,TTSYL,SYLINF,
     F NTMP1,NTMP2,NTMP3,NTMP4,TMP1,TMP2)
  500 END
CC
CC
CC
      FUNCTION MEET2(L,J)
      IF(L.GT.J)GO TO 10
      IF(L.EQ.J)GO TO 20
CC
CC   L LESS THAN J
CC
      MEET2=(J-2)*(J-1)/2+L+1
      RETURN
CC
CC   J LESS THAN L
CC
   10 MEET2=(L-2)*(L-1)/2+J+1
      RETURN
CC
CC   J EQUALS L
CC
   20 MEET2=1
      RETURN
      END
CC
CC
CC
      SUBROUTINE DYSTA2(NSAM,JPP,NSEL,X,NN,DYS,NDYST,JTMD,
     F VALMD,JHALT)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(NN*JPP),DYS(1+NSAM*(NSAM-1)/2)
      DIMENSION NSEL(NSAM),JTMD(JPP),VALMD(JPP)
      PP=JPP
      NLK=1
      DYS(1)=0.0
      DO 100 L=2,NSAM
      LSUBT=L-1
      LSEL=NSEL(L)
      DO 20 K=1,LSUBT
      KSEL=NSEL(K)
      CLK=0.0
      NLK=NLK+1
      NPRES=0
      DO 30 J=1,JPP
      NUMLJ=(LSEL-1)*JPP+J
      NUMKJ=(KSEL-1)*JPP+J
      IF(JTMD(J).GE.0)GO TO 40
      IF(X(NUMLJ).EQ.VALMD(J))GO TO 30
      IF(X(NUMKJ).EQ.VALMD(J))GO TO 30
   40 NPRES=NPRES+1
      IF(NDYST.NE.1)GO TO 50
      CLK=CLK+(X(NUMLJ)-X(NUMKJ))*(X(NUMLJ)-X(NUMKJ))
      GO TO 30
   50 CLK=CLK+DABS(X(NUMLJ)-X(NUMKJ))
   30 CONTINUE
      RPRES=NPRES
      IF(NPRES.NE.0)GO TO 60
      JHALT=1
      DYS(NLK)=-1.0
      GO TO 20
   60 IF(NDYST.NE.1)GO TO 70
      DYS(NLK)=DSQRT(CLK*(PP/RPRES))
      GO TO 20
   70 DYS(NLK)=CLK*(PP/RPRES)
   20 CONTINUE
  100 CONTINUE
      END
CC
CC
      SUBROUTINE RANDM(NRUN,RAN)
CC   WE PROGRAMMED THIS GENERATOR OURSELVES BECAUSE WE WANTED IT
CC   TO BE MACHINE INDEPENDENT. IT SHOULD RUN ON MOST COMPUTERS
CC   BECAUSE THE LARGEST INTEGER USED IS LESS THAN 2**30 . THE PERIOD
CC   IS 2**16=65536, WHICH IS GOOD ENOUGH FOR OUR PURPOSES.
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INTEGER*4 NRUN,K
      NRUN=NRUN*5761+999
      K=NRUN/65536
      NRUN=NRUN-K*65536
      RY=NRUN
      RAN=RY/65536.0
      RETURN
      END
CC
CC
      SUBROUTINE BSWAP2(KK,NSAM,NREPR,DYS,SKY,S,DYSMA,DYSMB,BETER)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION DYSMA(NSAM),DYSMB(NSAM),BETER(NSAM),NREPR(NSAM)
      DIMENSION DYS(1+NSAM*(NSAM-1)/2)
CC
CC   FIRST ALGORITHM: BUILD.
CC
      NNY=0
      DO 17 J=1,NSAM
      NREPR(J)=0
      DYSMA(J)=1.1*S+1.0
   17 CONTINUE
   20 DO 22 JA=1,NSAM
      IF(NREPR(JA).NE.0)GO TO 22
      BETER(JA)=0.
      DO 21 J=1,NSAM
      NJAJ=MEET2(JA,J)
      CMD=DYSMA(J)-DYS(NJAJ)
      IF(CMD.GT.0.0)BETER(JA)=BETER(JA)+CMD
   21 CONTINUE
   22 CONTINUE
      AMMAX=0.
      DO 31 JA=1,NSAM
      IF(NREPR(JA).NE.0)GO TO 31
      IF(BETER(JA).LT.AMMAX)GO TO 31
      AMMAX=BETER(JA)
      NMAX=JA
   31 CONTINUE
      NREPR(NMAX)=1
      NNY=NNY+1
      DO 41 J=1,NSAM
      NJN=MEET2(NMAX,J)
      IF(DYS(NJN).LT.DYSMA(J))DYSMA(J)=DYS(NJN)
   41 CONTINUE
      IF(NNY.NE.KK)GO TO 20
      SKY=0.
      DO 51 J=1,NSAM
      SKY=SKY+DYSMA(J)
   51 CONTINUE
      IF(KK.EQ.1)RETURN
      RSAM=NSAM
      ASKY=SKY/RSAM
CC
CC   SECOND ALGORITHM: SWAP.
CC
   60 DO 63 J=1,NSAM
      DYSMA(J)=1.1*S+1.0
      DYSMB(J)=1.1*S+1.0
      DO 62 JA=1,NSAM
      IF(NREPR(JA).EQ.0)GO TO 62
      NJAJ=MEET2(JA,J)
      IF(DYS(NJAJ).GE.DYSMA(J))GO TO 61
      DYSMB(J)=DYSMA(J)
      DYSMA(J)=DYS(NJAJ)
      GO TO 62
   61 IF(DYS(NJAJ).GE.DYSMB(J))GO TO 62
      DYSMB(J)=DYS(NJAJ)
   62 CONTINUE
   63 CONTINUE
      DZSKY=1.0
      DO 73 K=1,NSAM
      IF(NREPR(K).EQ.1)GO TO 73
      DO 72 JA=1,NSAM
      IF(NREPR(JA).EQ.0)GO TO 72
      DZ=0.
      DO 71 J=1,NSAM
      NJAJ=MEET2(JA,J)
      NKJ=MEET2(K,J)
      IF(DYS(NJAJ).NE.DYSMA(J))GO TO 70
      SMALL=DYSMB(J)
      IF(DYS(NJAJ).LT.SMALL)SMALL=DYS(NKJ)
      DZ=DZ-DYSMA(J)+SMALL
      GO TO 71
   70 IF(DYS(NKJ).LT.DYSMA(J))DZ=DZ-DYSMA(J)+DYS(NKJ)
   71 CONTINUE
      IF(DZ.GE.DZSKY)GO TO 72
      DZSKY=DZ
      KBEST=K
      NBEST=JA
   72 CONTINUE
   73 CONTINUE
      IF(DZSKY.GE.0.0)RETURN
      NREPR(KBEST)=1
      NREPR(NBEST)=0
      SKY=SKY+DZSKY
      GO TO 60
      END
CC
CC
      SUBROUTINE SELEC(KK,NN,JPP,NDYST,ZB,NSAM,MDATA,
     F JTMD,VALMD,NREPR,NSEL,DYS,X,NR,NAFS,TTD,RADUS,RATT,
     F NRNEW,NSNEW,NPNEW,NS,NP,NEW,TTNEW,RDNEW)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION NREPR(NSAM),NSEL(NSAM),DYS(1+NSAM*(NSAM-1)/2)
      DIMENSION NRNEW(NSAM),NSNEW(NSAM),NPNEW(NSAM),TTNEW(NSAM)
      DIMENSION RDNEW(NSAM)
      DIMENSION NS(NSAM),NR(KK),NP(NSAM),TTD(KK),RADUS(KK),RATT(KK)
      DIMENSION JTMD(JPP),VALMD(JPP),X(NN*JPP),NEW(NSAM)
CC
CC   NAFS = 1 IF A DISTANCE CANNOT BE CALCULATED
CC
      NAFS=0
CC
CC   IDENTIFICATION OF REPRESENTATIVE OBJECTS, AND INITIALIZATIONS
CC
      JK=0
      DO 10 J=1,NSAM
      IF(NREPR(J).EQ.0)GO TO 10
      JK=JK+1
      NR(JK)=NSEL(J)
      NS(JK)=0
      TTD(JK)=0.
      RADUS(JK)=-1.
      NP(JK)=J
   10 CONTINUE
CC
CC   ASSIGNMENT OF THE OBJECTS OF THE ENTIRE DATA SET TO A CLUSTER,
CC   COMPUTATION OF SOME STATISTICS, DETERMINATION OF THE
CC   NEW ORDERING OF THE CLUSTERS
CC
      ZB=0.
      PP=JPP
      NEWF=0
      JN=0
   15 JN=JN+1
      IF(MDATA.NE.0)GO TO 40
      DO 30 JK=1,KK
      DSUM=0.
      NRJK=NR(JK)
      IF (NRJK.EQ.JN) GOTO 25
      DO 20 JP=1,JPP
      NA=(NRJK-1)*JPP+JP
      NB=(JN-1)*JPP+JP
      TRA=DABS(X(NA)-X(NB))
      IF(NDYST.EQ.1)TRA=TRA*TRA
      DSUM=DSUM+TRA
   20 CONTINUE
      IF(JK.EQ.1)GO TO 25
      IF(DSUM.GE.DNULL)GO TO 30
   25 DNULL=DSUM
      JKABC=JK
   30 CONTINUE
      GO TO 80
   40 PRES=0.
      DO 70 JK=1,KK
      DSUM=0.
      NRJK=NR(JK)
      IF (NRJK.EQ.JN) GOTO 64
      ABC=0.
      DO 50 JP=1,JPP
      NA=(NRJK-1)*JPP+JP
      NB=(JN-1)*JPP+JP
      IF(JTMD(JP).GE.0)GO TO 45
      IF(X(NA).EQ.VALMD(JP))GO TO 50
      IF(X(NB).EQ.VALMD(JP))GO TO 50
   45 ABC=ABC+1.
      TRA=DABS(X(NA)-X(NB))
      IF(NDYST.EQ.1)TRA=TRA*TRA
      DSUM=DSUM+TRA
   50 CONTINUE
      IF(ABC.LT.0.5)GO TO 70
      DSUM=DSUM*ABC/PP
      IF(PRES.GT.0.5)GO TO 60
      PRES=1.
      GO TO 65
   60 IF(DSUM.GE.DNULL)GO TO 70
   64 IF(PRES.GT.0.5)GO TO 65
      PRES=1.
   65 DNULL=DSUM
      JKABC=JK
   70 CONTINUE
      IF(PRES.GT.0.5)GO TO 80
      NAFS=1
      RETURN
   80 IF(NDYST.EQ.1)DNULL=DSQRT(DNULL)
      ZB=ZB+DNULL
      TTD(JKABC)=TTD(JKABC)+DNULL
      IF(DNULL.GT.RADUS(JKABC))RADUS(JKABC)=DNULL
      NS(JKABC)=NS(JKABC)+1
      IF(NEWF.GE.KK)GO TO 90
      IF(NEWF.EQ.0)GO TO 84
      DO 82 JNEW=1,NEWF
      IF(JKABC.EQ.NEW(JNEW))GO TO 90
   82 CONTINUE
   84 NEWF=NEWF+1
      NEW(NEWF)=JKABC
   90 IF(JN.LT.NN)GO TO 15
CC
CC   A PERMUTATION IS CARRIED OUT ON VECTORS NR,NS,NP,TTD,RADUS
CC   USING THE INFORMATION IN VECTOR NEW.
CC
      DO 92 JK=1,KK
      NJK=NEW(JK)
      NRNEW(JK)=NR(NJK)
      NSNEW(JK)=NS(NJK)
      NPNEW(JK)=NP(NJK)
      TTNEW(JK)=TTD(NJK)
      RDNEW(JK)=RADUS(NJK)
   92 CONTINUE
      DO 94 JK=1,KK
      NR(JK)=NRNEW(JK)
      NS(JK)=NSNEW(JK)
      NP(JK)=NPNEW(JK)
      TTD(JK)=TTNEW(JK)
      RADUS(JK)=RDNEW(JK)
   94 CONTINUE

      DO 101 J=1,KK
      RNS=NS(J)
      TTD(J)=TTD(J)/RNS
  101 CONTINUE
      IF(KK.EQ.1)GO TO 150
CC
CC   COMPUTATION OF MINIMAL DISTANCE OF MEDOID KA TO ANY
CC   OTHER MEDOID FOR COMPARISON WITH THE RADIUS OF CLUSTER KA.
CC
      DO 120 KA=1,KK
      NSTRT=0
      NPA=NP(KA)
      DO 110 KB=1,KK
      IF(KB.EQ.KA)GO TO 110
      NPB=NP(KB)
      NPAB=MEET2(NPA,NPB)
      IF(NSTRT.EQ.0)THEN
         NSTRT=1
      ELSE
         IF(DYS(NPAB).GE.RATT(KA))GO TO 110
      ENDIF
  104 RATT(KA)=DYS(NPAB)
      IF(RATT(KA).NE.0.)GO TO 110
      RATT(KA)=-1.
  110 CONTINUE
      IF(RATT(KA).GT.(-0.5))RATT(KA)=RADUS(KA)/RATT(KA)
  120 CONTINUE
  150 END
CC
CC
      SUBROUTINE RESUL(KK,NN,JPP,NDYST,MDATA,JTMD,
     F VALMD,X,NRX,MTT)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(NN*JPP),NRX(KK),JTMD(JPP),VALMD(JPP),MTT(KK)
      PP=JPP
CC
CC   CLUSTERING VECTOR IS INCORPORATED INTO X, AND PRINTED.
CC
      JN=0
  100 JN=JN+1
      NJNB=(JN-1)*JPP
      DO 145 JK=1,KK
      IF(NRX(JK).EQ.JN)GO TO 220
  145 CONTINUE
      JNA=(JN-1)*JPP+1
      IF(MDATA.NE.0)GO TO 170
      DO 160 JK=1,KK
      DSUM=0.
      NRJK=(NRX(JK)-1)*JPP
      DO 150 J=1,JPP
      NA=NRJK+J
      NB=NJNB+J
      TRA=DABS(X(NA)-X(NB))
      IF(NDYST.EQ.1)TRA=TRA*TRA
      DSUM=DSUM+TRA
  150 CONTINUE
      IF(NDYST.EQ.1)DSUM=DSQRT(DSUM)
      IF(JK.EQ.1)DNULL=DSUM+0.1
      IF(DSUM.GE.DNULL)GO TO 160
      DNULL=DSUM
      JKSKY=JK
  160 CONTINUE
      GO TO 200
  170 DO 190 JK=1,KK
      DSUM=0.
      NRJK=(NRX(JK)-1)*JPP
      ABC=0.
      DO 180 J=1,JPP
      NA=NRJK+J
      NB=NJNB+J
      IF(JTMD(J).GE.0)GO TO 185
      IF(X(NA).EQ.VALMD(J))GO TO 180
      IF(X(NB).EQ.VALMD(J))GO TO 180
  185 ABC=ABC+1.
      TRA=DABS(X(NA)-X(NB))
      IF(NDYST.EQ.1)TRA=TRA*TRA
      DSUM=DSUM+TRA
  180 CONTINUE
      IF(NDYST.EQ.1)DSUM=DSQRT(DSUM)
      DSUM=DSUM*ABC/PP
      IF(JK.EQ.1)DNULL=DSUM+0.1
      IF(DSUM.GE.DNULL)GO TO 190
      DNULL=DSUM
      JKSKY=JK
  190 CONTINUE
  200 X(JNA)=JKSKY
  220 IF(JN.LT.NN)GO TO 100
      DO 230 JK=1,KK
      NRJK=NRX(JK)
      NRJKA=(NRJK-1)*JPP+1
      X(NRJKA)=JK
  230 CONTINUE

  300 DO 320 KA=1,KK
      MTT(KA)=0
      J=0
  325 J=J+1
      JA=(J-1)*JPP+1
      NXJA=IDINT(X(JA)+0.1)
      IF(NXJA.EQ.KA)MTT(KA)=MTT(KA)+1
      IF(J.LT.NN)GO TO 325
  320 CONTINUE
  330 END
CC
CC
      SUBROUTINE BLACK(KK,JPP,NN,NSAM,NBEST,DYS,SX,X,AVSYL,TTSYL,SYLINF,
     F NCLUV,NSEND,NELEM,NEGBR,SYL,SRANK)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION NCLUV(NSAM),NSEND(NSAM),NELEM(NSAM),NEGBR(NSAM)
      DIMENSION SYL(NSAM),SRANK(NSAM),AVSYL(KK),NBEST(NSAM)
      DIMENSION X(NN*JPP),DYS(1+NSAM*(NSAM-1)/2),SYLINF(NSAM,4)
CC
CC   CONSTRUCTION OF CLUSTERING VECTOR (NCLUV)
CC   OF SELECTED SAMPLE (NBEST).
CC
      DO 12 L=1,NSAM
      NCASE=NBEST(L)
      JNA=(NCASE-1)*JPP+1
      NCLUV(L)=IDINT(X(JNA)+0.1)
   12 CONTINUE
CC
CC   DRAWING OF THE SILHOUETTES
CC
      NSYLR=0
      TTSYL=0.0
      DO 100 NUMCL=1,KK
      NTT=0
      DO 30 J=1,NSAM
      IF(NCLUV(J).NE.NUMCL)GO TO 30
      NTT=NTT+1
      NELEM(NTT)=J
   30 CONTINUE
      DO 40 J=1,NTT
      NJ=NELEM(J)
      DYSB=1.1*SX+1.0
      NEGBR(J)=-1
      DO 41 NCLU=1,KK
      IF(NCLU.EQ.NUMCL)GO TO 41
      NBB=0
      DB=0.0
      DO 43 L=1,NSAM
      IF(NCLUV(L).NE.NCLU)GO TO 43
      NBB=NBB+1
      MJL=MEET2(NJ,L)
      DB=DB+DYS(MJL)
   43 CONTINUE
      BTT=NBB
      DB=DB/BTT
      IF(DB.GE.DYSB)GO TO 41
      DYSB=DB
      NEGBR(J)=NCLU
   41 CONTINUE
      IF(NTT.EQ.1)GO TO 50
      DYSA=0.0
      DO 45 L=1,NTT
      NL=NELEM(L)
      NJL=MEET2(NJ,NL)
      DYSA=DYSA+DYS(NJL)
   45 CONTINUE
      ATT=NTT-1
      DYSA=DYSA/ATT
      IF(DYSA.GT.0.0)GO TO 51
      IF(DYSB.GT.0.0)GO TO 52
   50 SYL(J)=0.0
      GO TO 40
   52 SYL(J)=1.0
      GO TO 40
   51 IF(DYSB.LE.0.0)GO TO 53
      IF(DYSB.GT.DYSA)SYL(J)=1.0-DYSA/DYSB
      IF(DYSB.LT.DYSA)SYL(J)=DYSB/DYSA-1.0
      IF(DYSB.EQ.DYSA)SYL(J)=0.0
      GO TO 54
   53 SYL(J)=-1.0
   54 IF(SYL(J).LE.(-1.0))SYL(J)=-1.0
      IF(SYL(J).GE.1.0)SYL(J)=1.0
   40 CONTINUE
      AVSYL(NUMCL)=0.0
      DO 60 J=1,NTT
      SYMAX=-2.0
      DO 70 L=1,NTT
      IF(SYL(L).LE.SYMAX)GO TO 70
      SYMAX=SYL(L)
      LANG=L
   70 CONTINUE
      NSEND(J)=LANG
      SRANK(J)=SYL(LANG)
      AVSYL(NUMCL)=AVSYL(NUMCL)+SRANK(J)
      SYL(LANG)=-3.0
   60 CONTINUE
      TTSYL=TTSYL+AVSYL(NUMCL)
      RTT=NTT
      AVSYL(NUMCL)=AVSYL(NUMCL)/RTT

      IF(NTT.GE.2)GOTO 75
      NCASE=NELEM(1)
      NSYLR=NSYLR+1
      SYLINF(NSYLR,1)=NUMCL
      SYLINF(NSYLR,2)=NEGBR(1)
      SYLINF(NSYLR,3)=0.0
      SYLINF(NSYLR,4)=NBEST(NCASE)
      GOTO 100
   75 DO 80 L=1,NTT
      LPLAC=NSEND(L)
      NCASE=NELEM(LPLAC)
      NSYLR=NSYLR+1
      SYLINF(NSYLR,1)=NUMCL
      SYLINF(NSYLR,2)=NEGBR(LPLAC)
      SYLINF(NSYLR,3)=SRANK(L)
      SYLINF(NSYLR,4)=NBEST(NCASE)
   80 CONTINUE
  100 CONTINUE
      RSAM=NSAM
      TTSYL=TTSYL/RSAM
      END
