\name{nlr}
\title{Nonlinear Regression}
\usage{
nlr(y, mu=NULL, p=NULL, dist="normal", wt=1, delta=1,
print.level=0, typsiz=abs(p), ndigit=10, gradtol=0.00001,
stepmax=10*sqrt(p\%*\%p), steptol=0.00001, iterlim=100, fscale=1)
}
\alias{nlr}
\alias{coefficients.nlr}
\alias{deviance.nlr}
\alias{df.residual.nlr}
\alias{fitted.values.nlr}
\alias{residuals.nlr}
\alias{weights.nlr}
\arguments{
\item{y}{The response vector.}
\item{mu}{A function of \code{p} giving the regression equation for the mean.}
\item{p}{Vector of initial estimates of the parameters.}
\item{dist}{The distribution to be used: normal, gamma, or inverse Gauss.}
\item{wt}{Weight vector.}
\item{delta}{Scalar or vector giving the unit of measurement for each
response value, set to unity by default. For example, if a response is
measured to two decimals, delta=0.01. If the response is transformed,
this must be multiplied by the Jacobian. For example, with a log
transformation, \code{delta=1/y}.}
\item{others}{Arguments controlling \code{\link{nlm}}.}
}
\description{
\code{nlr} fits a user-specified nonlinear regression equation by
least squares (normal) or its generalization for the gamma and inverse
Gauss distributions.
}
\value{
A list of class nlr is returned.
The printed output includes the -log likelihood (not the deviance),
the corresponding AIC, the parameter estimates, standard
errors, and correlations. A list is returned that contains all of the
relevant information calculated, including error codes.
}
\seealso{
\code{\link{lm}}, \code{\link{glm}}, \code{\link{glmm}},
\code{\link{gnlmm}}, \code{\link{gnlr}}, \code{\link{gnlr3}},
\code{\link{fmr}}.
}
\examples{
# linear regression
mu1 <- function(p) p[1]+p[2]*x
summary(lm(y~x))
nlr(y,mu=mu1,p=c(3,2))
# nonlinear regression
mu2 <- function(p) p[1]+p[2]*x^p[3]
nlr(y,mu=mu2,p=c(3,2,1))
}
