\name{tvctomat}
\title{Create or add to a time-varying covariate (tvcov) object}
\usage{
tvctomat(tvcov, names=NULL, oldtvcov=NULL)
}
\alias{tvctomat}
\alias{print.tvccov}
\arguments{
\item{tvcov}{A list of matrices with time-varying covariate values
for each individual (one column per variable) or one matrix or
dataframe of such covariate values (when there is only one such
covariate).}
\item{names}{The names of the covariates (if the matrices do not have
column names).}
\item{oldtvcov}{An object of class, tvcov, to which tvcov is to be
added.}
}
\description{
\code{tvctovmat} transforms a list of matrices with time-varying
covariates for each individual or one matrix or dataframe of such
covariate values into an object of class, tvcov.

Such objects can be printed.
}
\value{
Returns an object of class, tvcov, containing a matrix for the
covariates (z$tvcov) with one row per response per individual, a list
of their names, and a vector giving the number of observations per
individual (z$nobs).
}
\seealso{
\code{\link{carma}}, \code{\link{elliptic}}, \code{\link{gettvc}},
\code{\link{kalcount}}, \code{\link{kalseries}}, \code{\link{nbkal}},
\code{\link{read.list}}, \code{\link{restovec}}, \code{\link{tcctomat}}.
}
