% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{RadiationEffects_df}
\alias{RadiationEffects_df}
\title{Radiation Dose Effects on Chromosomal Abnormality}
\format{
A data frame with 27 observations and 4 variables:
\describe{
  \item{cells}{Number of cells observed (integer).}
  \item{ca}{Number of chromosomal abnormalities (integer).}
  \item{doseamt}{Amount of gamma radiation dose (numeric).}
  \item{doserate}{Rate of gamma radiation dose (numeric).}
}
}
\source{
Data taken from the faraway package.
Based on the study by Purott R. and Reeder E. (1976): *The effect of changes in dose rate on the yield of chromosome aberrations in human lymphocytes exposed to gamma radiation*. Mutation Research, 35, 437–444.
}
\usage{
data(RadiationEffects_df)
}
\description{
This dataset, RadiationEffects_df, is a data frame containing data from an experiment conducted to examine the effects of gamma radiation on the number of chromosomal abnormalities observed. The data explores the relationships between radiation dose, dose rate, and chromosomal changes.
}
\details{
The dataset name has been kept as 'RadiationEffects_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the OncoDataSets package and assists users in identifying
its specific characteristics. The suffix '_df' indicates that the dataset is a data frame. The original content has not been modified in any way.
}
