% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_envi.R
\name{read_envi}
\alias{read_envi}
\title{Read ENVI data}
\usage{
read_envi(
  file,
  header = NULL,
  spectral_smooth = F,
  sigma = c(1, 1, 1),
  metadata = list(file_name = basename(file), user_name = NULL, contact_info = NULL,
    organization = NULL, citation = NULL, spectrum_type = NULL, spectrum_identity = NULL,
    material_form = NULL, material_phase = NULL, material_producer = NULL,
    material_purity = NULL, material_quality = NULL, material_color = NULL,
    material_other = NULL, cas_number = NULL, instrument_used = NULL,
    instrument_accessories = NULL, instrument_mode = NULL, spectral_resolution = NULL,
    laser_light_used = NULL, number_of_accumulations = NULL, 
    
    total_acquisition_time_s = NULL, data_processing_procedure = NULL,
    level_of_confidence_in_identification = NULL, other_info = NULL, license =
    "CC BY-NC"),
  ...
)
}
\arguments{
\item{file}{name of the binary file.}

\item{header}{name of the ASCII header file. If \code{NULL}, the name of the
header file is guessed by looking for a second file with the same basename as
\code{file} but with .hdr extension.}

\item{spectral_smooth}{logical value determines whether spectral smoothing
will be performed.}

\item{sigma}{if \code{spectral_smooth} then this option applies the 3d
standard deviations for the \code{gaussianSmooth} function from the
\code{mmand} package to describe how spectral smoothing occurs on each dimension.
The first two dimensions are x and y, the third is the wavenumbers.}

\item{metadata}{a named list of the metadata; see
\code{\link{as_OpenSpecy}()} for details.}

\item{\ldots}{further arguments passed to the submethods.}
}
\value{
An \code{OpenSpecy} object.
}
\description{
This function allows ENVI data import.
}
\details{
ENVI data usually consists of two files, an ASCII header and a binary data
file. The header contains all information necessary for correctly reading
the binary file via \code{\link[caTools]{read.ENVI}()}.
}
\seealso{
\code{\link{read_spec}()} for reading .y(a)ml, .json, or .rds (OpenSpecy)
files;
\code{\link{read_text}()}, \code{\link{read_asp}()}, \code{\link{read_spa}()},
\code{\link{read_spc}()}, and \code{\link{read_jdx}()} for text files, .asp,
.spa, .spa, .spc, and .jdx formats, respectively;
\code{\link{read_opus}()} for reading .0 (OPUS) files;
\code{\link{read_zip}()} and \code{\link{read_any}()} for wrapper functions;
\code{\link[caTools]{read.ENVI}()}
\code{\link[mmand]{gaussianSmooth}()}
}
\author{
Zacharias Steinmetz, Claudia Beleites
}
