% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_multi.R
\name{read_any}
\alias{read_any}
\alias{read_many}
\alias{read_zip}
\title{Read spectral data from multiple files}
\usage{
read_any(file, c_spec = T, c_spec_args = list(range = NULL, res = NULL), ...)

read_many(file, ...)

read_zip(file, ...)
}
\arguments{
\item{file}{file to be read from or written to.}

\item{c_spec}{logical, if multiple spectra should be concatenated or not.
Multiple spectra will return a list if this is false.}

\item{c_spec_args}{list of arguments passed to \code{c_spec()}}

\item{\ldots}{further arguments passed to the submethods.}
}
\value{
All \code{read_*()} functions return \code{OpenSpecy} objects if a single
spectrum or map is provided, otherwise they provide a list of \code{OpenSpecy} objects.
}
\description{
Wrapper functions for reading files in batch.
}
\details{
\code{read_any()} provides a single function to quickly read in any of the
supported formats, it assumes that the file extension will tell it how to
process the spectra.
\code{read_zip()} provides functionality for reading in spectral map files
with ENVI file format or as individual files in a zip folder. If individual
files, spectra are concatenated.
\code{read_many()} provides functionality for reading multiple files
in a character vector and will return a list.
}
\examples{
\dontshow{data.table::setDTthreads(2)}
read_extdata("raman_hdpe.csv") |> read_any()
read_extdata("ftir_ldpe_soil.asp") |> read_any()
read_extdata("testdata_zipped.zip") |> read_many()
read_extdata("CA_tiny_map.zip") |> read_many()

}
\seealso{
\code{\link{read_spec}()} for submethods.
\code{\link{c_spec}()} for combining lists of Open Specys.
}
\author{
Zacharias Steinmetz, Win Cowger
}
