% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bumpVersion.R
\name{bumpVersion}
\alias{bumpVersion}
\title{Bump Package 'Version:' and 'Date:' in DESCRIPTION File}
\usage{
bumpVersion(
  element = "patch",
  pkg.repo = ".",
  news = file.path(pkg.repo, "NEWS.md"),
  plain_news = TRUE
)
}
\arguments{
\item{element}{\code{character}, one of \code{"major"}, \code{"minor"}, \code{"patch"} (default)
to be bumped.}

\item{pkg.repo}{Path to package repository folder. Default is current working
directory, i.e. \code{"."}.}

\item{news}{The \code{NEWS.md} file of the repo (assumed to be in top level path).
If this exists, the first line of that file will be rewritten to be
"\<packagename\> \<major.minor.patch\>". Note that the current
implementation assumes that the NEWS file is in \code{.md} format. A plain NEWS
file (for R-help pages) will be generated automatically.}

\item{plain_news}{whether to generate a plain NEWS file in the package root
directory from the \code{NEWS.md} file supplied to argument 'news'.}
}
\description{
This function let's you bump the version number and creation date of your
package's \code{DESCRIPTION} file. Additionally, it bumps the version numbers of a
\code{NEWS.md} file and automatically generates a corresponding plain NEWS file
(for R-help pages). Supported versioning system is
\href{https://semver.org/}{MAJOR.MINOR.PATCH}.
}
\seealso{
\url{https://semver.org/}
}
\author{
Tim Appelhans
}
