% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchGFS.R
\name{matchGFS}
\alias{matchGFS}
\title{Match GFS Environmental Data}
\usage{
matchGFS(x, progress = TRUE, keepMatch = TRUE)
}
\arguments{
\item{x}{a dataframe with columns \code{UTC}, \code{Latitude} and
\code{Longitude} to add environmental data to}

\item{progress}{logical flag to display download progress}

\item{keepMatch}{logical flag to keep the "matchLat", "matchLong",
and "matchTime" columns with the output. These are only used
to verify which coordinates within the NetCDF were matched
to your data.}
}
\value{
a dataframe with wind (m/s) and precipitation rate (kg/m^2/s)
columns added:
\describe{
\item{windU}{Eastward wind velocity}
\item{windV}{Northward wind velocity}
\item{windMag}{Total wind magnitude}
\item{precRate}{Precipitation rate}
\item{matchLat}{Cosest latitude coordinate matched in GFS}
\item{matchLong}{Closest longitude coordinate matched in GFS}
\item{matchTime}{Closest time coordinate matched in GFS}
}
Where the last three columns are only included if \code{keepMatch=TRUE}
}
\description{
Downloads and matches wind and precipitation data
from the Global Forecast System (GFS) weather model. Data is
downloaded from the National Center for Atmospheric Research
data server \url{https://gdex.ucar.edu/datasets/d084001/}.
The particular GFS dataset downloaded is the closest "forecast"
dataset to the particular time (e.g. .f000 or .f003)
}
\examples{
# API response may be slow for this example
\donttest{
gps <- data.frame(Latitude=c(33.2, 33.5,33.6),
                  Longitude=c(-118.1, -118.4, -119),
                  UTC=as.POSIXct(
                    c('2022-04-28 05:00:00',
                      '2022-04-28 10:00:00',
                      '2022-04-28 20:00:00'), tz='UTC'))
gps <- matchGFS(gps)
}

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
