% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgainStart.R
\docType{data}
\name{APTSIZE}
\alias{APTSIZE}
\title{Apartment Size}
\format{
A data frame with 15 observations on the following two variables:
\itemize{
\item \code{size} (apartment size in square meters)
\item \code{location} (\code{factor} with two levels \code{SanJorge} and \code{Mendebaldea})
}
}
\usage{
APTSIZE
}
\description{
Size of apartments in Mendebaldea, Spain, and San Jorge, Spain
}
\examples{
p <- ggplot(data = APTSIZE, aes(x = location, y = size, fill = location)) + 
labs(x = "", y = "Apartment size (square meters)") + 
scale_x_discrete(breaks = c("Mendebaldea", "SanJorge"), 
labels =c("Mendebaldea", "San Jorge")) + scale_fill_brewer()
p + geom_boxplot()
# remove the legend
p + geom_boxplot() + guides(fill = "none")
# violin plot
p + geom_violin(scale = 'area') + guides(fill = "none")
p + geom_violin(scale = 'count') + guides(fill = "none")
p + geom_violin() + geom_boxplot(width = 0.15, fill = 'black') + guides(fill = "none") + 
stat_summary(fun = median, geom = "point", fill = "white", shape = 23, size = 3)
# dotplot
p + geom_dotplot(binaxis = "y", stackdir = "center", binwidth = 3) + 
guides(fill = "none")
p + geom_boxplot(width = 0.4) + geom_dotplot(binaxis = "y", stackdir = "center", 
binwidth = 3) + guides(fill = "none") + scale_fill_brewer(type = "qual", palette = 1)
# base graphics
boxplot(size ~ location, data = APTSIZE, col = c("red", "yellow"), 
ylab = "Apartment size (square meters)")
}
\references{
Ugarte, M. D., Militino, A. F., and Arnholt, A. T. 2015. \emph{Probability and Statistics with R}, Second Edition. Chapman & Hall / CRC.
}
\keyword{datasets}
