% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PASWR-package.R
\docType{data}
\name{HSwrestler}
\alias{HSwrestler}
\title{High School Wrestlers}
\format{
A data frame with 78 observations on the following 9 variables:
\describe{ 
\item{AGE}{age of wrestler in years}
\item{HT}{height of wrestler in inches} 
\item{WT}{weight ofwrestler in pounds} 
\item{ABS}{abdominal fat}
\item{TRICEPS}{tricep fat} 
\item{SUBSCAP}{subscapular fat}
\item{HWFAT}{hydrostatic fat} 
\item{TANFAT}{Tanita fat}
\item{SKFAT}{skin fat} }
}
\source{
Data provided by Dr. Alan Utter, Department of Health Leisure and
Exercise Science, Appalachian State University.
}
\description{
The body fat of 78 high school wrestlers was measured using three separate
techniques, and the results are stored in the data frame \code{HSwrestler}.
The techniques used were hydrostatic weighing (\code{HWFAT}), skin fold
measurements (\code{SKFAT}), and the Tanita body fat scale (\code{TANFAT}).
Data are used in Examples 10.11, 12.11, and 12.12.
}
\examples{

FAT <- c(HSwrestler$HWFAT, HSwrestler$TANFAT, HSwrestler$SKFAT)
GROUP <- factor(rep(c("HWFAT", "TANFAT", "SKFAT"), rep(78, 3)))
BLOCK <- factor(rep(1:78, 3))
friedman.test(FAT ~ GROUP | BLOCK)

}
\references{
Ugarte, M. D., Militino, A. F., and Arnholt, A. T. (2008)
\emph{Probability and Statistics with R}. Chapman & Hall/CRC.
}
\keyword{datasets}
