% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PASWR-package.R
\docType{data}
\name{Sundig}
\alias{Sundig}
\title{Workstation Comparison}
\format{
A data frame with 5 observations on the following 3 variables:
\describe{ 
\item{SUN}{time in seconds for a Sun workstation to complete a simulation} 
\item{DIGITAL}{time in seconds for a Digital
workstation to complete a simulation} 
\item{d}{difference between \code{Sun} and \code{Digital}} 
}
}
\source{
Ugarte, M. D., Militino, A. F., and Arnholt, A. T. (2008)
\emph{Probability and Statistics with R}. Chapman & Hall/CRC.
}
\description{
To compare the speed differences between two different brands of
workstations (Sun and Digital), the times each brand took to complete
complex simulations was recorded. Five complex simulations were selected,
and the five selected simulations were run on both workstations. The
resulting times in minutes for the five simulations are stored in data frame
\code{Sundig}.
}
\examples{

with(data = Sundig, 
t.test(SUN, DIGITAL, paired = TRUE)$conf)

}
\keyword{datasets}
