% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sensewear_report.R
\name{Sensewear_report}
\alias{Sensewear_report}
\title{Generate Report for SenseWear activity data.}
\usage{
Sensewear_report(data)
}
\arguments{
\item{data}{csv file from SenseWear}
}
\value{
\code{Year}	The calendar year of recorded event

\code{Month}	The calendar month of recorded event

\code{Day}	The calendar day of recorded event

\code{Dayofweek}	The day of that week

\code{Time_on_body_Hrs} Total time (hours) of SenseWear on body

\code{Time_waking_wearing_Hrs}	Total waking time (hours) during wearing time

\code{Time_on_body_percent}	 Percent of wearing time of a day

\code{Steps} Total steps of the day

\code{Time_lying_Hrs}  Total lying time (hours)

\code{Time_sleeping_Hrs} Total sleeping time (hours)

\code{Time_sed_Hrs} Total sedentary time (hours)

\code{TEE_Kcal} Total energy expenditure (Kcal)

\code{Time_waking_Sedentary_Hrs}	When the wearer is waking, the total sedentary time (hours)

\code{Percent_waking_sed}	When the wearer is waking, the percentage of sedentary time to wearing time

\code{Time_waking_Mild_Hrs}	When the wearer is waking, the total mild time (hours)

\code{Percent_waking_mild}	When the wearer is waking, the percentage of mild time to wearing time

\code{Time_waking_Moderate_Hrs}	When the wearer is waking, the total moderate time (hours)

\code{Percent_waking_moderate}	When the wearer is waking, the percentage of moderate time to wearing time

\code{Time_waking_MVPA_Hrs}	When the wearer is waking, the total MVPA time (hours)

\code{Percent_waking_MVPA}	When the wearer is waking, the percentage of MVPA time to wearing time

\code{Time_waking_Vigorous_Hrs}	When the wearer is waking, the total vigorous time (hours)

\code{Percent_waking_vigorous}	When the wearer is waking, the percentage of vigorous time to wearing time

\code{No_sed_breaks} Number of sedentary breaks (at least one minute interruption counting as a break)

\code{Time_all_break_length_Hrs} Summation of time (hours) of breaks

\code{Average_EE_break_kcal} Average energy expenditure of breaks

\code{Time_below_1_METs_Hrs}	Total time (hours) of MET less than 1

\code{Time_btw_1_2_METs_Hrs}	Total time (hours) of MET between 1 and 2

\code{Time_btw_2_3_METs_Hrs}	Total time (hours) of MET between 2 and 3

\code{Time_btw_3_4_METs_Hrs}	Total time (hours) of MET between 3 and 4

\code{Time_btw_4_5_METs_Hrs}	Total time (hours) of MET between 4 and 5

\code{Time_btw_5_6_METs_Hrs}	Total time (hours) of MET between 5 and 6

\code{Time_above_6_METS_Hrs}	Total time (hours) of MET over 6

\code{Steps_above_1.5_METs} Summation of step count when energy expenditure is >1.5 METs with step counts not equal to 0

\code{EE_steps_above_1.5METs_kcal} Summation of energy expenditure for in Kcal when energy expenditure is >1.5 METs with step counts not equal to 0

\code{Steps_above_3_METs} Summation of step count when energy expenditure is >3 METs with step counts not equal to 0

\code{EE_steps_above_3METs_kcal} Summation of energy expenditure for in Kcal when energy expenditure is >3 METs with step counts not equal to 0

\code{Time_100_steps_per_day_Hrs} Summation of time (hours) for Steps>=100 per minute

\code{PAEE_above_1.5METs_kcal}  Summation of energy expenditure in Kcal when energy expenditure is >1.5 METs

\code{Time_PAEE_1.5METs_Hrs}  Summation of time (hours) when energy expenditure is >1.5 METs

\code{PAEE_above_3METs_kcal} Summation of energy expenditure in Kcal when energy expenditure is >3 METs

\code{Time_PAEE_3METs_Hrs} Summation of time (hours) energy expenditure is >3 METs

\code{No_unBouted_10min}  Summation of number of MVPA bout which energy expenditure is >3 METs and length is less than 10 minutes

\code{EE_unBouted_10min_Kcal} Summation of energy expenditure of bout which energy expenditure is >3 METs and length is less than 10 minutes

\code{Time_unBouted_10min_Hrs} Summation of time (hours) of bout which length is less than 10 minutes

\code{No_Bout_10min} Summation of number of bout which length is more than 10 minutes

\code{EE_Bouted_10min_Kcal} Summation of energy expenditure of MVPA bout which length is more than 10 minutes

\code{Time_Bouted_10min_Hrs} Summation of time (hours) of MVPA bout which length is more than 10 minutes

\code{No_Bout_20min} Summation of number of MVPA bout which length is more than 20 minutes

\code{EE_Bouted_20min_Kcal} Summation of number of MVPA bout which length is more than 20 minutes

\code{Time_Bouted_20min_Hrs} Summation of time (hours) of MVPA bout which length is more than 20 minutes

\code{No_Bout_30min} Summation of number of MVPA bout which length is more than 30 minutes

\code{EE_Bouted_30min_Kcal} Summation of energy expenditure of MVPA bout which length is more than 30 minutes

\code{Time_Bouted_30min_Hrs}  Summation of time (hours) of MVPA bout which length is more than 30 minutes

\code{Mean_bout_duration}  Mean MVPA bout duration which bout length is more than 10 minutes: Time_Bouted_10min_Hrs/No_Bout_10min

\code{No_Bouts_Extra_Long_steps} The number of bouts of 'extra long' (>500 steps) walks in each day

\code{No_Bouts_Long_steps} The number of bouts of 'long' (100-499 steps) walks in each day

\code{No_Bouts_Moderate_steps} The number of bouts of 'moderate' (20-99 steps) walks in each day

\code{No_Bouts_Short_steps} The number of bouts of 'short' walks (<20 steps) in each day

\code{Mean_cadence_extra_long} Mean cadence (steps/min) in 'extra long' bouts of walking

\code{Mean_cadence_long} Mean cadence (steps/min) in 'long' bouts of walking

\code{Mean_cadence_moderate} Mean cadence (steps/min) in 'moderate' bouts of walking

\code{Mean_cadence_short} Mean cadence (steps/min) in 'short' bouts of walking

\code{Mean_cadence_day} Mean cadence (steps/min) in each day
}
\description{
Summarize sedentary, mild, moderate, and MVPA related activity measures.
}
\details{
MVPA long bout is defined as at least 10 consecutive minutes with METs>=3 (allowing 2 min below that threshold).
}
\examples{
Sensewear_report(sampledata)
}

