% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rolling_groups}
\alias{rolling_groups}
\title{Loop along a vector, returning n elements at a time in a list}
\usage{
rolling_groups(values, n = 2L)
}
\arguments{
\item{values}{IntegerVector. The vector to loop along}

\item{n}{int. The number of elements to return in each element of the
resulting list}
}
\value{
a list in which each element contains \code{n} elements from
  \code{values}
}
\description{
Loop along a vector, returning n elements at a time in a list
}
\note{
For this function, the output elements contain raw values from
  \code{values}, whereas for \code{\link{get_indices}} the output elements
  contain the positions (i.e., indices) rather than the raw values
}
\examples{
groups <- rolling_groups(0:50, 3)
head(groups)
tail(groups)
}
\seealso{
\code{\link{get_indices}}
}
