% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PBtD.R
\name{PBtD}
\alias{PBtD}
\title{Partially Balanced t-Designs (PBtDesigns)}
\usage{
PBtD(v, Series)
}
\arguments{
\item{v}{Number of treatments}

\item{Series}{Series of Partially Balanced t-Designs}
}
\value{
Three series are given for generating of partially balanced t-designs namely Series 1, Series 2 and Series 3.

Series 1 are designs having equal block sizes and with treatment structure 4(t + 1).

Series 2 are designs having equal block sizes and with treatment as a prime number.

Series 3 consists of designs with unequal block sizes and with treatment structure n(n-1)/2.

This function generates partially balanced t-designs along with their parameters, information matrices, average variance factors and canonical efficiency factors.
}
\description{
This package contains functions named PBtD() for generating partially balanced t-designs along with their parameters, information matrices, average variance factors and canonical efficiency factors.
}
\examples{
library(PBtDesigns)
PBtD(7,2)
}
\references{
1) Karmakar, S., Varghese, C., Jaggi, S. & Harun, M. (2021)< DOI:10.1080/03610918.2021.2008436>. " Partially Balanced t-designs ".

2) Raghavarao, D. & Zhou, B. (1998)<https://doi.org/10.1080/03610929808832657> " Universal optimality of UE 3-designs for a competing effects model ".

3) Karmakar, S., Varghese, C., Jaggi, S. & Harun, M. (2022)." Partially Balanced t-designs with unequal block sizes ".
}
