% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doCE.R
\name{doCE}
\alias{doCE}
\title{Compute cumulative eigenvalue information}
\usage{
doCE(x, ...)
}
\arguments{
\item{x}{Either a \code{PCADSC} or a \code{pcaRes} object.}

\item{...}{If \code{doCE} is called on a \code{pcaRes} object, the full dataset must also
be supplied (as \code{data}), as well as the number of resampling steps (\code{B}).}
}
\description{
Computes the information that is needed in order to make a \code{\link{CEPlot}}
from a \code{PCADSC} or \code{pcaRes} object. Typically, this function is called on a partial
\code{PCADSC} object in order to add \code{CEInfo} (see examples).
}
\examples{
#load iris data
data(iris)

#Define grouping variable, grouping the observations by whether their species is
#Setosa or not
iris$group <- "setosa"
iris$group[iris$Species != "setosa"] <- "non-setosa"
iris$Species <- NULL

\dontrun{
#make a partial PCADSC object, splitting the data by "group"
irisPCADSC <- PCADSC(iris, "group", doCE = FALSE)

#No CEInfo available
irisPCADSC$CEInfo

#Add and show CEInfo
irisPCADSC <- doCE(irisPCADSC)
irisPCADSC$CEInfo
}

#Make a partial PCADSC object and only add CE information with no
#bootstrapping (and thus no test)
irisPCADSC_fast <- PCADSC(iris, "group", doAngle = FALSE,
  doChroma = FALSE, doCE = FALSE)
irisPCADSC_fast <- doCE(irisPCADSC_fast, B = 100)
irisPCADSC_fast$CEInfo

}
\seealso{
\code{\link{CEPlot}}, \code{\link{PCADSC}}
}

