% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doChroma.R
\name{doChroma}
\alias{doChroma}
\title{Compute chroma information}
\usage{
doChroma(x)
}
\arguments{
\item{x}{Either a \code{PCADSC} or a \code{pcaRes} object.}
}
\description{
Computes the information that is needed in order to make a \code{\link{chromaPlot}}
from a \code{PCADSC} or \code{pcaRes} object. Typically, this function is called on a partial
\code{PCADSC} object in order to add \code{chromaInfo} (see examples).
}
\examples{
#load iris data
data(iris)

#Define grouping variable, grouping the observations by whether their species is
#Setosa or not
iris$group <- "setosa"
iris$group[iris$Species != "setosa"] <- "non-setosa"
iris$Species <- NULL

\dontrun{
#make a partial PCADSC object, splitting the data by "group"
irisPCADSC <- PCADSC(iris, "group", doChroma = FALSE)

#No chromaInfo available
irisPCADSC$chromaInfo

#Add and show chromaInfo
irisPCADSC <- doChroma(irisPCADSC)
irisPCADSC$chromaInfo
}

#Make a partial PCADSC object and only add chroma information for a
#faster runtime
irisPCADSC_fast <- PCADSC(iris, "group", doAngle = FALSE,
  doChroma = FALSE, doCE = FALSE)
irisPCADSC_fast <- doChroma(irisPCADSC_fast)
irisPCADSC_fast$chromaInfo

}
\seealso{
\code{\link{chromaPlot}}, \code{\link{PCADSC}}
}

