% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcl.R
\name{pclfit}
\alias{pclfit}
\title{Fit a Proximal Causal Learning Model}
\usage{
pclfit(pcl_object, method = "POR")
}
\arguments{
\item{pcl_object}{an pcl object}

\item{method}{method used to fit}
}
\value{
returns the average causal effect
}
\description{
Fit a proximal causal learning model
}
\examples{
n <- 100
outcome <- rnorm(n, 0, 1)
trt <- rbinom(n, 1, 0.5)
trt_pxy <- matrix(rnorm(n, 0, 1), ncol = 1)
out_pxy <- matrix(rnorm(n, 0, 1), ncol = 1)
covariates <- matrix(rnorm(n, 0, 1), ncol = 1)
pcl_object <- pcl(outcome, trt, trt_pxy, out_pxy, covariates)
fit <- pclfit(pcl_object)
}
