% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart.Efront.R
\name{chart.Efront}
\alias{chart.Efront}
\title{Create Efficient Frontier}
\usage{
chart.Efront(
  returns,
  pspec,
  firstEfront = TRUE,
  gmv = TRUE,
  maxSR = TRUE,
  rf = 0.003,
  xlim = NULL,
  ylim = NULL,
  xlab = NULL,
  ylab = NULL,
  n.portfolios = 10
)
}
\arguments{
\item{returns}{A multivarite xts returns object}

\item{pspec}{PortfolioAnalytics portfolio specification object}

\item{firstEfront}{Logical variable, default TRUE}

\item{gmv}{Logical variable, default TRUE}

\item{maxSR}{Logical variable, default TRUE}

\item{rf}{Risk-free rate, default 0.003}

\item{xlim}{Numeric value, default NULL}

\item{ylim}{Numeric value, default NULL}

\item{xlab}{Numeric value, default NULL}

\item{ylab}{Numeric value, default NULL}

\item{n.portfolios}{Number of efficient frontier portfolios, default 10}
}
\value{
No value returned, instead plots of efficient frontiers for use by bootEfronts()
}
\description{
Utility function for creating initial efficient frontier, and
for creating subsequent bootstrap efficient frontiers created, all of which
are created by the PortfolioAnalytics function create.EfficientFrontier.
}
\details{
The variable firstEfront is set to TRUE for the initial efficient
frontier plot, but is set to FALSE for the bootstrap replicate efficient
frontier plots. The choices gmv = TRUE and maxSR = TRUE result in bullet points
at those locations on the initial efficient frontier plot
}
\examples{
args(chart.Efront)
}
