% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PDMIFCLUSTGLM.R
\name{PDMIFCLUSTGLM}
\alias{PDMIFCLUSTGLM}
\title{PDMIFCLUSTGLM}
\usage{
PDMIFCLUSTGLM(X, Y, FAMILY, NLfactors, Maxit = 100, tol = 0.001)
}
\arguments{
\item{X}{The (NT) times p design matrix, without an intercept where N=number of individuals, T=length of time series, p=number of explanatory variables.}

\item{Y}{The T times N panel of response where N=number of individuals, T=length of time series.}

\item{FAMILY}{A description of the error distribution and link function to be used in the model just like in glm functions.}

\item{NLfactors}{A pre-specified number of factors in each groups (see example).}

\item{Maxit}{A maximum number of iterations in optimization. Default is 100.}

\item{tol}{Tolerance level of convergence. Default is 0.001.}
}
\value{
A list with the following components:
\itemize{
\item Label: The estimated group membership for each of the individuals.
\item Coefficients: The estimated heterogeneous coefficients.
\item Lower05: Lower end (5\%) of the 90\% confidence interval of the regression coefficients.
\item Upper95: Upper end (95\%) of the 90\% confidence interval of the regression coefficients.
\item GroupFactors: The estimated group-specific factors.
\item GroupLoadings: The estimated factor loadings for each group.
\item pval: p-value for testing hypothesis on heterogeneous coefficients.
\item Se: Standard error of the estimated regression coefficients.
}
}
\description{
Under a pre-specified number of groups and the number of common factors, this function implements clustering for N individual units by nonlinear heterogeneous panel data models with interactive effects.
Exponential family of distributions are used
Each of individuals in the group are subject to the group-specific unobserved common factors.
}
\examples{
fit <- PDMIFCLUSTGLM(data6X,data6Y,binomial(link=logit),c(1,1,1),3,0.5)
}
\references{
Ando, T. and Bai, J. (2016) Panel data models with grouped factor structure under unknown group membership Journal of Applied Econometrics, 31, 163-191.

Ando, T. and Bai, J. (2017) Clustering huge number of financial time series: A panel data approach with high-dimensional predictors and factor structures. Journal of the American Statistical Association, 112, 1182-1198.
}
