% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PDMIFQVAR.R
\name{PDMIFQVAR}
\alias{PDMIFQVAR}
\title{PDMIFQVAR}
\usage{
PDMIFQVAR(Y, LAG, TAU, Nfactors, Maxit = 100, tol = 0.001)
}
\arguments{
\item{Y}{The T times N panel of response where N=number of individuals, T=length of time series.}

\item{LAG}{The number of lags from y_t-1 to y_t-LAG used in the VAR.}

\item{TAU}{A pre-specified quantile point.}

\item{Nfactors}{A pre-specified number of common factors.}

\item{Maxit}{A maximum number of iterations in optimization. Default is 100.}

\item{tol}{Tolerance level of convergence. Default is 0.001.}
}
\value{
A list with the following components:
\itemize{
\item Coefficients: The estimated heterogeneous coefficients.
\item Lower05: Lower end (5\%) of the 90\% confidence interval of the regression coefficients.
\item Upper95: Upper end (95\%) of the 90\% confidence interval of the regression coefficients.
\item Factors: The estimated common factors across groups.
\item Loadings: The estimated quantile point under a given tau.
\item Predict: The conditional expectation of response variable.
\item pval: p-value for testing hypothesis on heterogeneous coefficients.
\item Se: Standard error of the estimated regression coefficients.
}
}
\description{
This function estimates heterogeneous quantile panel data VAR models with interactive effects.
}
\examples{
fit <- PDMIFQVAR(data8Y,2,0.1,2,5,0.8)
}
\references{
Ando, T. and Bai, J. (2020) Quantile co-movement in financial markets Journal of the American Statistical Association.
}
