% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/55_HELPERS_.R
\name{num.slice}
\alias{num.slice}
\title{Slice numeric variable}
\usage{
num.slice(x, mapping, sc = c(NA, NaN, Inf, -Inf), sc.r = "SC")
}
\arguments{
\item{x}{Numeric vector to be discretized.}

\item{mapping}{Data frame with compulsory columns: \code{x.min} and \code{x.max} which represent the discretized
boundaries.}

\item{sc}{Numeric vector with special case elements. Default values are \code{c(NA, NaN, Inf, -Inf)}.}

\item{sc.r}{Character vector used for replacement of special cases. If supplied as one
element vector, it will be recycled to the length of \code{sc}. Default value is \code{"SC"}.}
}
\value{
The command \code{num.slice} returns vector of discretized values and coded special cases.
}
\description{
\code{num.slice} implements manual discretization of numeric vector for a given boundaries. This procedure is one
of the helper functions which are handy for the model monitoring phase (i.e. after model implementation).
}
\examples{
suppressMessages(library(PDtoolkit))
data(gcd)
x <- gcd$maturity
#artificially add some special values
x[1:5] <- Inf
x[6:7] <- NA
#perform monotonic grouping in order to get bins' boundaries
mbin <- sts.bin(x = x, y = gcd$qual, sc.method = "separately")
mbin[[1]]
#slice numeric variable
sn <- num.slice(x = x, 
	      mapping = data.frame(x.min = mbin[[1]]$x.min[-c(1, 2)], 
					 x.max = mbin[[1]]$x.max[-c(1, 2)]), 
	      sc = c(NA, NaN, Inf, -Inf), 
	      sc.r = "SC")
#compare automatic and manual binning
table(mbin[[2]], useNA = "always")
table(sn, useNA = "always")
}
