% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_function.R
\name{f_surv_model_pred_tp_gr}
\alias{f_surv_model_pred_tp_gr}
\title{Compute Transition Probabilities for Survival Model Predictions}
\usage{
f_surv_model_pred_tp_gr(
  ngroups,
  time_pred,
  time_unit,
  surv_model_pred_gr,
  cols_tp
)
}
\arguments{
\item{ngroups}{Integer, number of groups.}

\item{time_pred}{Numeric vector of prediction times (currently unused).}

\item{time_unit}{Numeric, time unit for transition probability calculation.}

\item{surv_model_pred_gr}{List of group predictions.
Each group's table should have a time column in column 1 and survival-related columns from 2:cols_tp.}

\item{cols_tp}{Integer, index of the last survival-related column (i.e., use columns 2:cols_tp).}
}
\value{
Named list of data.frames with transition probabilities (truncated after threshold).
}
\description{
Compute Transition Probabilities for Survival Model Predictions
}
\examples{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
form <- stats::as.formula(survival::Surv(years, status) ~ group)
surv_model <- f_surv_model(
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  ngroups = nlevels(group),
  form = form,
  spline_mod = FALSE,
  cure_mod = FALSE,
  cure_link = "logistic",
  group_names = levels(group)
)
surv_model_pred <- f_surv_model_pred(
  ngroups = nlevels(group),
  time_pred = seq(0, 5000, 365.25),
  surv_model = surv_model,
  spline_mod = FALSE,
  cure_mod = FALSE,
  group_names = levels(group)
)
surv_model_pred_gr <- f_surv_model_pred_gr(
  ngroups = nlevels(group),
  surv_model = surv_model,
  surv_model_pred = surv_model_pred,
  spline_mod = FALSE,
  cure_mod = FALSE
)
f_surv_model_pred_tp_gr(
  ngroups = nlevels(group),
  time_pred = seq(0, 5000, 365.25),
  time_unit = 365.25/12,
  surv_model_pred_gr = surv_model_pred_gr,
  cols_tp = 8
)

}
